\name{rshift.ppp}
\alias{rshift.ppp}
\title{Randomly Shift a Point Pattern}
\description{
  Randomly shifts the points of a point pattern.
}
\usage{
   \method{rshift}{ppp}(X, \dots, which=NULL, group)
}
\arguments{
  \item{X}{Point pattern to be subjected to a random shift.
    An object of class \code{"ppp"}
  }
  \item{\dots}{
    Arguments that determine the random shift. See Details.
  }
  \item{group}{
    Optional. Factor specifying a grouping of the points of \code{X},
    or \code{NULL} indicating that all points belong to the same group.
    Each group will be shifted together, and
    separately from other groups.
    By default, points in a marked point pattern are grouped
    according to their mark values,
    while points in an unmarked point pattern are treated as a single group.
  }
  \item{which}{
    Optional. Identifies which groups of the pattern will be shifted,
    while other groups are not shifted. A vector of levels of \code{group}.
  }
}
\value{
  A point pattern (object of class \code{"ppp"}).
}
\details{
  This operation randomly shifts the locations of the points
  in a point pattern.

  The function \code{rshift} is generic. This function \code{rshift.ppp}
  is the method for point patterns.

  The most common use of this function is to shift the
  points in a multitype point pattern.
  By default, points of the same type are shifted in parallel
  (i.e. points of a common type are shifted by a common displacement vector),
  and independently of other types.
  This is useful for testing the hypothesis of independence of types
  (the null hypothesis that the sub-patterns of points of each type
  are independent point processes).

  In general the points of \code{X} are divided into groups,
  then the points within a group are shifted by a common
  random displacement vector. Different groups of points are shifted
  independently. The grouping is determined as follows:
  \itemize{
    \item
    If the argument \code{group} is present, then this determines the grouping.
    \item
    Otherwise, if \code{X} is a multitype point pattern,
    the marks determine the grouping.
    \item
    Otherwise, all points belong to a single group.
  }
  The argument \code{group} should be a factor, of length equal to the
  number of points in \code{X}. Alternatively \code{group} may be \code{NULL},
  which specifies that all points of \code{X} belong to a single group.

  By default, every group of points will be shifted.
  The argument \code{which} indicates that only some of the groups
  should be shifted, while other groups should be left unchanged.
  \code{which} must be a vector of levels of \code{group}
  (for example, a vector of types in a multitype pattern)
  indicating which groups are to be shifted. 

  The displacement vector, i.e. the vector
  by which the data points are shifted,
  is generated at random.
  Parameters that control the randomisation
  and the handling of edge effects are passed through
  the \code{\dots} argument. They are
  \describe{
    \item{radius,width,height}{
      Parameters of the random shift vector.
    }
  \item{edge}{
    String indicating how to deal with edges of the pattern.
    Options are \code{"torus"}, \code{"erode"} and \code{"none"}.
  }
  \item{clip}{
    Optional. Window to which the final point pattern should be clipped.
  }
  }
  If the window is a rectangle, the \emph{default} behaviour is 
  to generate a displacement vector at random with equal probability
  for all possible displacements. This means that the \eqn{x} and
  \eqn{y} coordinates of the displacement vector are independent random
  variables, uniformly distributed over the range of possible coordinates.

  Alternatively, the displacement vector can be generated by
  another random mechanism, controlled by the arguments
  \code{radius}, \code{width} and \code{height}. 
  \describe{
    \item{rectangular:}{
      if \code{width} and \code{height} are given, then 
      the displacement vector is uniformly distributed
      in a rectangle of these dimensions, centred at
      the origin.  The maximum possible displacement in the \eqn{x}
      direction is \code{width/2}. The maximum possible displacement in
      the \eqn{y} direction is \code{height/2}. The \eqn{x} and \eqn{y}
      displacements are independent. (If \code{width} and \code{height}
      are actually equal to the dimensions of the observation window,
      then this is equivalent to the default.)
    }
    \item{radial:}{
      if \code{radius} is given, then the displacement vector is
      generated by choosing a random point inside a disc of
      the given radius, centred at the origin, with uniform probability
      density over the disc. Thus the argument \code{radius} determines
      the maximum possible displacement distance.
      The argument \code{radius} is incompatible with the
      arguments \code{width} and \code{height}.
    }
  }

  The argument \code{edge} controls what happens when 
  a shifted point lies outside the window of \code{X}.
  Options are:
  \describe{
    \item{"none":}{
      Points shifted outside the window of \code{X}
      simply disappear. 
    }
    \item{"torus":}{
      Toroidal or periodic boundary.
      Treat opposite edges of the window as identical, so that a point
      which disappears off the right-hand edge will re-appear at the
      left-hand edge. This is called a ``toroidal shift'' because it makes the
      rectangle topologically equivalent to the surface of a torus
      (doughnut).

      The window must be a rectangle. Toroidal shifts are undefined
      if the window is non-rectangular.
    }
    \item{"erode":}{
      Clip the point pattern to a smaller window.

      If the random displacements are generated by a radial
      mechanism (see above), then the window of \code{X}
      is eroded by a distance equal to the value of the argument
      \code{radius}, using \code{\link{erosion}}.

      If the random displacements are generated by a rectangular
      mechanism, then the window of \code{X} is
      (if it is not rectangular) eroded by a distance
      \code{max(height,width)} using \code{\link{erosion}};
      or (if it is rectangular) trimmed by a margin of width \code{width}
      at the left and right sides and trimmed by a margin of
      height \code{height} at the top and bottom.
      
      The rationale for this is that the clipping window is
      the largest window for which edge effects can be ignored.
    }
  }
  The optional argument \code{clip} specifies a smaller window
  to which the pattern should be restricted.
}
\seealso{
  \code{\link{rshift}},
  \code{\link{rshift.psp}}
}
\examples{
   data(amacrine)

   # random toroidal shift
   # shift "on" and "off" points separately
   X <- rshift(amacrine)

   # shift "on" points and leave "off" points fixed
   X <- rshift(amacrine, which="on")

   # shift all points simultaneously
   X <- rshift(amacrine, group=NULL)

   # maximum displacement distance 0.1 units
   X <- rshift(amacrine, radius=0.1)

   # shift with erosion
   X <- rshift(amacrine, radius=0.1, edge="erode")
}
\author{Adrian Baddeley
  \email{adrian@maths.uwa.edu.au}
  \url{http://www.maths.uwa.edu.au/~adrian/}
  and Rolf Turner
  \email{r.turner@auckland.ac.nz}
}
\keyword{spatial}
\keyword{datagen}
