% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/task_spectral_indic.R
\name{raw_sdr}
\alias{raw_sdr}
\title{Spectral Density Ratio (SDR) indicator}
\usage{
raw_sdr(mat, sdr_low_range = NULL, sdr_high_range = NULL)
}
\arguments{
\item{mat}{A matrix with continuous values, or a logical matrix 
(TRUE/FALSE).}

\item{sdr_low_range}{The range of values (in proportion) to 
use for the computation of the spectral density ratio.
For example, for the lowest 20\% (default value), set \code{sdr_low_range}
to \code{c(0, .2)}.}

\item{sdr_high_range}{The range of values (in proportion) to 
use for the computation of the spectral density ratio. For example, for 
the highest 20\% (default value), set \code{sdr_high_range} to 
\code{c(.8, 1)}.}
}
\value{
The SDR values computed on the matrix as a named vector
}
\description{
Compute the ratio of low frequencies over high frequencies
  of the r-spectrum.
}
\details{
SDR measures the increase in long-range correlations before a critical point. 
  It is the ratio of the average low frequency value over high frequency 
  values. In this implementation, an increase in SDR implies a "reddening" 
  of the \link[=rspectrum]{r-spectrum}. See also \code{\link{spectral_sews}} for 
  a more complete description. 

Low and high frequencies are averaged in order to compute the SDR. The 
  parameters \code{sdr_low_range} and \code{sdr_high_range} control which 
  frequencies are selected for averaging. For example 
  \code{sdr_low_range = c(0, .2)} (default) uses the lower 20% to compute 
  the average of low frequencies. \code{sdr_high_range = c(.8, 1)} uses the 
  higher 20% for the average of high frequencies.
}
\examples{

\dontrun{ 
data(serengeti)
serengeti.sdr <- raw_sdr(serengeti[[1]], 
                         sdr_low_range = c(0, 0.2), 
                         sdr_high_range = c(0.8, 1))
compute_indicator(serengeti, raw_sdr)
}

}
\references{
Carpenter, S.R. & Brock, W.A. (2010). Early warnings of regime shifts in 
  spatial dynamics using the discrete Fourier transform. Ecosphere
}
\seealso{
\code{\link{indictest}}, 
  \code{\link{rspectrum}}, \code{\link{plot_spectrum}}, 
  \code{\link{spectral_sews}}, \code{\link{extract_spectrum}}
}
