% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_spatial_predictors.R
\name{filter_spatial_predictors}
\alias{filter_spatial_predictors}
\title{Removes redundant spatial predictors}
\usage{
filter_spatial_predictors(
  data = NULL,
  predictor.variable.names = NULL,
  spatial.predictors.df = NULL,
  cor.threshold = 0.5
)
}
\arguments{
\item{data}{Data frame with a response variable and a set of predictors. Default: \code{NULL}}

\item{predictor.variable.names}{Character vector with the names of the predictive variables. Every element of this vector must be in the column names of \code{data}. Default: \code{NULL}}

\item{spatial.predictors.df}{Data frame of spatial predictors.}

\item{cor.threshold}{Numeric between 0 and 1, maximum Pearson correlation between any pair of the selected variables. Default: \code{0.50}}
}
\value{
A data frame with non-redundant spatial predictors.
}
\description{
Removes spatial predictors that are pair-wise correlated with other spatial predictors (which happens when there are several close distance thresholds), and spatial predictors correlated with non-spatial predictors.
}
\examples{
if(interactive()){

#loading data
data("distance_matrix")
data("plant_richness_df")

#computing Moran's Eigenvector Maps
spatial.predictors.df <- mem_multithreshold(
  distance_matrix = distance_matrix,
  distance.thresholds = c(0, 1000)
  )

#filtering spatial predictors
spatial.predictors.df <- filter_spatial_predictors(
  data = plant_richness_df,
  predictor.variable.names = colnames(plant_richness_df)[5:21],
  spatial.predictors.df = spatial.predictors.df,
  cor.threshold = 0.50
 )


}
}
