% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quadrats.R
\name{quadrats}
\alias{quadrats}
\title{Quadrats}
\usage{
quadrats(x, s = 250, n = 100, r = NULL, sp = FALSE)
}
\arguments{
\item{x}{A sp or sf polygon object defining extent}

\item{s}{Radius defining single or range of sizes of quadrats}

\item{n}{Number of quadrats}

\item{r}{A rotation factor for random rotation, default is NULL}

\item{sp}{(FALSE | TRUE) Output sp class object}
}
\value{
an sf or sp polygon object with rotated polygon(s)
}
\description{
Creates quadrat polygons for sampling or analysis
}
\note{
The radius (s) parameter can be a single value or a range of values, 
representing a randomization range of resulting quadrat sizes. The
rotation (r) parameter can also be used to defined a fixed rotation or
random range of quadrat rotations. You can specify each of these parameters
using an explicit vector that will be sampled eg., seq(100,300,0.5)
}
\examples{
\donttest{
library(sf)
library(terra) 

# read meuse data and create convex hull 
 data(meuse, package = "sp")
   meuse <- st_as_sf(meuse, coords = c("x", "y"), 
                     crs = 28992, agr = "constant") 
     e <- st_convex_hull(st_union(meuse))

 # Fixed size 250 and no rotation 
 s <- quadrats(e, s = 250, n = 10)
   plot(st_geometry(s))
  
 # Variable sizes 100-300 and rotation of 0-45 degrees
 s <- quadrats(e, s = c(100,300), n = 10, r = c(0,45))
   plot(st_geometry(s))
 
 # Variable sizes 100-300 and no rotation 
 s <- quadrats(e, s = c(100,300), n = 10)
  plot(st_geometry(s))
}     
}
