% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp.subsample.R
\name{pp.subsample}
\alias{pp.subsample}
\title{Point process random subsample}
\usage{
pp.subsample(
  x,
  n,
  window = "hull",
  sigma = "Scott",
  wts = NULL,
  gradient = 1,
  edge = FALSE
)
}
\arguments{
\item{x}{An sp class SpatialPointsDataFrame or SpatialPoints object}

\item{n}{Number of random samples to generate}

\item{window}{Type of window (hull or extent)}

\item{sigma}{Bandwidth selection method for KDE, default is 'Scott'. Options are 'Scott', 'Stoyan', 'Diggle', 'likelihood', and 'geometry'}

\item{wts}{Optional vector of weights corresponding to point pattern}

\item{gradient}{A scaling factor applied to the sigma parameter used to adjust the gradient decent of the density estimate. The default is 1, for no adjustment (downweight < 1 | upweight > 1)}

\item{edge}{Apply Diggle edge correction (TRUE/FALSE)}
}
\value{
sp class SpatialPointsDataFrame containing random subsamples
}
\description{
Generates random subsample based on density estimate of observations
}
\note{
The window type creates a convex hull by default or, optionally, uses the maximum extent (envelope). 

Available bandwidth selection methods are:
  Scott (Scott 1992), Scott's Rule for Bandwidth Selection (1st order)
  Diggle (Berman & Diggle 1989), Minimise the mean-square error via cross validation (2nd order)  
  likelihood (Loader 1999), Maximum likelihood cross validation (2nd order)
  geometry, Bandwidth is based on simple window geometry (1st order)
  Stoyan (Stoyan & Stoyan 1995), Based on pair-correlation function (strong 2nd order)

Note; resulting bandwidth can vary widly by method. the 'diggle' method is intended for selecting bandwidth representing 2nd order spatial variation whereas the 'scott' method will represent 1st order trend. the 'geometry' approach will also represent 1st order trend. for large datasets, caution should be used with the 2nd order 'likelihood' approach, as it is slow and computationally expensive. finally, the 'stoyan' method will produce very strong 2nd order results. '

Depends: sp, spatstat
}
\examples{
 
require(spatstat)
require(sp) 
data(bei)  
  trees <- as(bei, 'SpatialPoints')
    n=round(length(trees) * 0.10, digits=0)  
      trees.wrs <- pp.subsample(trees, n=n, window='hull')   
        plot(trees, pch=19, col='black')
          plot(trees.wrs, pch=19, col='red', add=TRUE) 
            box()
             title('10\% subsample')
          legend('bottomright', legend=c('Original sample', 'Subsample'), 
                 col=c('black','red'),pch=c(19,19))   

}
\references{
Berman, M. and Diggle, P. (1989) Estimating weighted integrals of the second-order intensity of a spatial point process. Journal of the Royal Statistical Society, series B 51, 81-92. 
Berman, M. and Diggle, P. (1989) Estimating weighted integrals of the second-order intensity of a spatial point process. Journal of the Royal Statistical Society, series B 51, 81-92.

Fithian, W & T. Hastie (2013) Finite-sample equivalence in statistical models for presence-only data. Annals of Applied Statistics 7(4): 1917-1939

Hengl, T., H. Sierdsema, A. Radovic, and A. Dilo (2009) Spatial prediction of species distributions from occurrence-only records: combining point pattern analysis, ENFA and regression-kriging. Ecological Modelling, 220(24):3499-3511

Loader, C. (1999) Local Regression and Likelihood. Springer, New York.

Scott, D.W. (1992) Multivariate Density Estimation. Theory, Practice and Visualization. New York, Wiley.

Stoyan, D. and Stoyan, H. (1995) Fractals, random shapes and point fields: methods of geometrical statistics. John Wiley and Sons.

Warton, D.i., and L.C. Shepherd (2010) Poisson Point Process Models Solve the Pseudo-Absence Problem for Presence-only Data in Ecology. The Annals of Applied Statistics, 4(3):1383-1402
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
