% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runFunctions.R
\name{spathialPrefiltering}
\alias{spathialPrefiltering}
\title{Prefilter data}
\usage{
spathialPrefiltering(X, boundary_ids)
}
\arguments{
\item{X}{data points}

\item{boundary_ids}{names of the start and ending points, to be treated separately}
}
\value{
A list of objects
\itemize{
  \item mask: indexes of the data points to preserv
  \item boundary_ids: the filtered boundary ids
}
}
\description{
Regularized K-means for principal path: prefiltering
}
\examples{
# Load data matrix X
load(system.file('extdata','X.rda',package='spathial',mustWork=TRUE))
# Load description vector X_labels
load(system.file('extdata','X_labels.rda',package='spathial',mustWork=TRUE))
# Run spathialBoundary
boundaryRes <- spathialBoundaryIds(X, X_labels, mode=2, from=3, to=6)
X <- boundaryRes$X
X_labels <- boundaryRes$X_labels
boundary_ids <- boundaryRes$boundary_ids
# Run spathial spathialPrefilterinh with the output of the function spathialBoundaryIds
filterRes <- spathialPrefiltering(X, boundary_ids)
# Extract prefiltering results
mask <- filterRes$mask
boundary_ids <- filterRes$boundary_ids
X <- X[mask,]
}
