% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measles2.R
\name{measles2}
\alias{measles2}
\title{Measles in UK: spatPomp generator with shared or unit-specific parameters}
\usage{
measles2(
  U = 6,
  dt = 2/365,
  N = 391,
  expandedParNames = c("R0", "c", "A", "muIR", "muEI", "sigmaSE", "rho", "psi", "g",
    "S_0", "E_0", "I_0"),
  contractedParNames = NULL,
  simulated = FALSE,
  basic_params = c(alpha = 0.98, iota = 0.1, R0 = 30, c = 0.3, A = 0.5, muIR = 52, muEI =
    52, muD = 0.02, sigmaSE = 0.15, rho = 0.5, psi = 0.15, g = 400, S_0 = 0.032, E_0 =
    5e-05, I_0 = 4e-05)
)
}
\arguments{
\item{U}{An integer from 1 to 40 specifying the number of cities to be represented in the spatPomp object.}

\item{dt}{a numeric (in unit of years) that is used as the Euler time-increment for simulating measles data}

\item{N}{An integer from 1 to 391 specifying the number of time points.}

\item{expandedParNames}{specifies parameters that are defined for each unit. This also allows unit perturbations for a parameter with a value shared across units.}

\item{contractedParNames}{specifies parameters having a shared value across units. Remaining parameters that are neither expanded nor contracted are considered fixed, and will not have a transformation defined for them.}

\item{simulated}{determines whether to return a simulation from the model or the
UK measles data}

\item{basic_params}{A named vector used to specify shared parameters or unit-specific parameters
having common values for each unit.}
}
\value{
An object of class \sQuote{spatPomp} representing a \code{U}-dimensional spatially coupled measles POMP model.
}
\description{
Generate a spatPomp object for measles in the top-\code{U} most populous cities in England and Wales.
The model is adapted from He et al. (2010) with gravity transport following Park and Ionides (2019).
The structure of this spatPomp is designed to accommodate shared and unit-specific parameters.
If carrying out spatiotemporal iterated filtering for shared parameters via ibpf, it is necessary to
have a unit-specific expansion and so these parameters should be included in expandedParNames.
This model and data correspond to the biweekly analysis of Park and Ionides (2020) and
Ionides et al (2021). There are small differences with the weekly model and data of
He et al (2010) and Ionides, Ning and Wheeler (2022).
}
\examples{
# Complete examples are provided in the package tests
\dontrun{
m <- measles2(U = 5)
# See all the model specifications of the object
spy(m)
}
}
\references{
\he2010

\park2020

\ionides2021

\ionides2022
}
