% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abc_utilities.R
\name{create_abc_settings_object}
\alias{create_abc_settings_object}
\title{Creates ensemble-specific parameters for ABC analysis}
\usage{
create_abc_settings_object(parameters, measures, built_ensemble,
  normalise_values = FALSE, normalise_result = FALSE,
  file_out = TRUE)
}
\arguments{
\item{parameters}{Array containing the names of the parameters for which
posterior distributions will be generated}

\item{measures}{Names of the simulation output responses which the ensemble
predicts}

\item{built_ensemble}{An ensemble object created by spartan}

\item{normalise_values}{Whether the data provided by the EasyABC algorithm
should be normalised (as the ensemble must take data between 0 and 1).
More than likley this is TRUE, to ensure the posterior distributions are
presented in their correct scale}

\item{normalise_result}{Whether the results produced in running abc
generated parameter sets using the ensemble should be rescaled.}

\item{file_out}{Whether the settings file should be output to file (TRUE)
or as an R object (FALSE)}
}
\value{
Object containing attributes needed for abc analysis
}
\description{
The EasyABC model wrapper can only take one parameter input: the parameter
values. This is problematic as to generate a prediction for those values,
we must provide the names of the simulation parameters and measures, the
built ensemble, and whether or not the parameter set and responses have
been normalised. To get around that problem, this method creates an object
in the working directory that contains these values, and the ensemble abc
wrapper provided in spartan can then read these in. Thus, this method
MUST be run before using the EasyABC package with the ensemble
}
