% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lhc_analysis_netlogo.R
\name{lhc_process_netlogo_result}
\alias{lhc_process_netlogo_result}
\title{Analyses Netlogo simulations generated for a latin-hypercube based sensitivity analysis}
\usage{
lhc_process_netlogo_result(FILEPATH, LHCSAMPLE_RESULTFILENAME,
  SPARTAN_PARAMETER_FILE, NUMSAMPLES, MEASURES, LHC_ALL_SIM_RESULTS_FILE,
  TIMESTEP)
}
\arguments{
\item{FILEPATH}{Directory where either the simulation runs can be found}

\item{LHCSAMPLE_RESULTFILENAME}{Name of the result file generated by Netlogo, for a LHC parameter sample.}

\item{SPARTAN_PARAMETER_FILE}{Location of the file output by the latin-hypercube sampling method, containing the parameters on which this experiment was performed}

\item{NUMSAMPLES}{The number of parameter subsets that were generated in the LHC design}

\item{MEASURES}{Array containing the names of the Netlogo output measures which are used to analyse the simulation.}

\item{LHC_ALL_SIM_RESULTS_FILE}{Name of the LHC Summary file to be generated. Contains each parameter set alongside the result gained when the simulation was run under that criteria.}

\item{TIMESTEP}{The timestep of the Netlogo simulation being analysed}
}
\description{
Takes each parameter value set generated by the hypercube in turn, and
analyses the Netlogo simulation results.  For each parameter set, there
will be n simulation results. This method goes through these results,
producing a file containing the median of each output measure for each
of the n runs. Thus, if a Netlogo simulation was replicated 10 times,
the median file will contain 10 medians for each simulation output measure.
Once this has been created, the user should run
\code{lhc_generateLHCSummary}, \code{lhc_generatePRCoEffs}, and
\code{lhc_graphMeasuresForParameterChange} as per analysing any data
in spartan that was not generated by Netlogo
}
