% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparsebnUtils-prior.R
\name{specify.prior}
\alias{specify.prior}
\title{Build a black list based on prior knowledge}
\usage{
specify.prior(roots = NULL, leaves = NULL, nodes, indices = FALSE)
}
\arguments{
\item{roots}{Vector of root nodes. May be character or integer.}

\item{leaves}{Vector of leaf nodes. May be character or integer.}

\item{nodes}{Full vector of node names of the entire network. Both
\code{roots} and \code{leaves} must be a subset of this vector.}

\item{indices}{Logical: Return indices or character names?}
}
\description{
Utility for specifying known root and leaf nodes in a network, to be used
in conjunction with the \code{blacklist} argument of network estimation
methods.
}
\details{
Builds an (m+k)x2 matrix, where m is the number of user-specified root
nodes and k is the number of user-specified leaf nodes.

\itemize{
\item A \emph{root} node is any node without any parents, i.e. with no
incoming edges.
\item A \emph{leaf} node is any node without any children, i.e. with no
outgoing edges.
}
}
