% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_logistic_regression.R
\name{ml_logistic_regression}
\alias{ml_logistic_regression}
\title{Spark ML -- Logistic Regression}
\usage{
ml_logistic_regression(x, response, features, intercept = TRUE, alpha = 0,
  lambda = 0, weights.column = NULL, iter.max = 100L,
  ml.options = ml_options(), ...)
}
\arguments{
\item{x}{An object coercable to a Spark DataFrame (typically, a
\code{tbl_spark}).}

\item{response}{The name of the response vector (as a length-one character
vector), or a formula, giving a symbolic description of the model to be
fitted. When \code{response} is a formula, it is used in preference to other
parameters to set the \code{response}, \code{features}, and \code{intercept}
parameters (if available). Currently, only simple linear combinations of
existing parameters is supposed; e.g. \code{response ~ feature1 + feature2 + ...}.
The intercept term can be omitted by using \code{- 1} in the model fit.}

\item{features}{The name of features (terms) to use for the model fit.}

\item{intercept}{Boolean; should the model be fit with an intercept term?}

\item{alpha, lambda}{Parameters controlling loss function penalization (for e.g.
lasso, elastic net, and ridge regression). See \strong{Details} for more
information.}

\item{weights.column}{The name of the column to use as weights for the model fit.}

\item{iter.max}{The maximum number of iterations to use.}

\item{ml.options}{Optional arguments, used to affect the model generated. See
\code{\link{ml_options}} for more details.}

\item{...}{Optional arguments. The \code{data} argument can be used to
specify the data to be used when \code{x} is a formula; this allows calls
of the form \code{ml_linear_regression(y ~ x, data = tbl)}, and is
especially useful in conjunction with \code{\link{do}}.}
}
\description{
Perform logistic regression on a Spark DataFrame.
}
\details{
Spark implements for both \eqn{L1} and \eqn{L2} regularization in linear
regression models. See the preamble in the
\href{http://spark.apache.org/docs/latest/ml-classification-regression.html}{Spark Classification and Regression}
documentation for more details on how the loss function is parameterized.

In particular, with \code{alpha} set to 1, the parameterization
is equivalent to a \href{https://en.wikipedia.org/wiki/Lasso_(statistics)}{lasso}
model; if \code{alpha} is set to 0, the parameterization is equivalent to
a \href{https://en.wikipedia.org/wiki/Tikhonov_regularization}{ridge regression} model.
}
\seealso{
Other Spark ML routines: \code{\link{ml_als_factorization}},
  \code{\link{ml_decision_tree}},
  \code{\link{ml_generalized_linear_regression}},
  \code{\link{ml_gradient_boosted_trees}},
  \code{\link{ml_kmeans}}, \code{\link{ml_lda}},
  \code{\link{ml_linear_regression}},
  \code{\link{ml_multilayer_perceptron}},
  \code{\link{ml_naive_bayes}},
  \code{\link{ml_one_vs_rest}}, \code{\link{ml_pca}},
  \code{\link{ml_random_forest}},
  \code{\link{ml_survival_regression}}
}
