% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_feature_transformation.R
\name{ft_quantile_discretizer}
\alias{ft_quantile_discretizer}
\title{Feature Transformation -- QuantileDiscretizer}
\usage{
ft_quantile_discretizer(x, input_col = NULL, output_col = NULL,
  n_buckets = 5)
}
\arguments{
\item{x}{An object (usually a \code{spark_tbl}) coercable to a Spark DataFrame.}

\item{input_col}{The name of the input column(s).}

\item{output_col}{The name of the output column.}

\item{n_buckets}{The number of buckets to use.}
}
\description{
Takes a column with continuous features and outputs a column with binned
categorical features. The bin ranges are chosen by taking a sample of the
data and dividing it into roughly equal parts. The lower and upper bin bounds
will be -Infinity and +Infinity, covering all real values. This attempts to
find numBuckets partitions based on a sample of the given input data, but it
may find fewer depending on the data sample values.
}
\details{
Note that the result may be different every time you run it, since the sample
strategy behind it is non-deterministic.
}
\seealso{
See \url{http://spark.apache.org/docs/latest/ml-features.html} for
  more information on the set of transformations available for DataFrame
  columns in Spark.

Other feature transformation routines: \code{\link{ft_binarizer}},
  \code{\link{ft_bucketizer}},
  \code{\link{ft_discrete_cosine_transform}},
  \code{\link{ft_elementwise_product}},
  \code{\link{ft_index_to_string}},
  \code{\link{ft_one_hot_encoder}},
  \code{\link{ft_sql_transformer}},
  \code{\link{ft_string_indexer}},
  \code{\link{ft_vector_assembler}},
  \code{\link{sdf_mutate}}
}

