\name{Signal RGB Calculation}
\alias{RGBfromXYZ}
\alias{RGBfromLab}
\alias{SignalRGBfromLinearRGB}
\title{Calculate Signal RGB from Linear RGB, XYZ, or Lab}

\description{Calculate signal RGB from linear RGB, XYZ, or Lab}

\usage{
SignalRGBfromLinearRGB( RGB, space='sRGB', which='scene', TF=NULL, maxSignal=1 )

RGBfromXYZ( XYZ, space='sRGB', which='scene', TF=NULL, maxSignal=1 ) 

RGBfromLab( Lab, space='sRGB', which='scene', TF=NULL, maxSignal=1 ) 
}

\arguments{
\item{RGB}{a numeric Nx3 matrix with linear RGB coordinates in the rows,
or a vector that can be converted to such a matrix, by row.
The RGB may be outside the corresponding domain box (either scene or display), see \bold{Details}.}

\item{XYZ}{a numeric Nx3 matrix with CIE XYZ coordinates in the rows, or a vector that can be converted to such a matrix, by row.
The XYZ are assumed to be viewed under the white-point of the given RGB \code{space}.}

\item{Lab}{a numeric Nx3 matrix with CIE Lab coordinates in the rows, or a vector that can be converted to such a matrix, by row.}

\item{space}{the name of an installed RGB space.
The name matching is partial and case-insensitive.}

\item{which}{either \code{'scene'} or \code{'display'}.
For \code{RGBfromXYZ()} \code{which} describes the input XYZ.
For \code{SignalRGBfromLinearRGB()} \code{which} describes the input RGB.
% Usually the OOTF for the space is the identity and so these two are the same.
}

\item{TF}{if not \code{NULL}, \code{TF} is a \code{TransferFunction}
that overrides the appropriate transfer function of \code{space}.
\code{TF} can also be a positive number.
If \code{TF=1}, then \code{TF} is set to \code{identity.TF},
so the returned RGB values are actually linear, and they are not clamped to the appropriate domain box
(see \bold{Value}).
If \code{TF!=1} it is used to create either
\code{power.EOTF()} or \code{power.OETF()} as approriate.
If \code{TF} is not \code{NULL} in \code{SignalRGBfromLinearRGB()}, then \code{space} is ignored.
}

\item{maxSignal}{maximum value of non-linear \code{RGB}.
Other common values are 100, 255, 1023, 4095, and 65535.
Even when 1, they are still taken to be non-linear Signal values.}
}

\value{
a \code{data.frame} with N rows and these columns
\item{RGB}{signal RGB.
If \code{TF} is not the identity, the computed linear RGBs are clamped to [0,1]\eqn{^3} if necessary,
which implies that the output signal RGBs are inside the cube [0,\code{maxSignal}]\eqn{^3}.
Values are not rounded.}

\item{OutOfGamut}{a logical, TRUE means one or more of the computed linear RGBs were actually clamped to [0,1].}

In \code{RGBfromLab()}, if a=b=0 exactly, the R=G=B exactly.

In case of error, the functions return NULL.
}

\details{
In \code{RGBfromXYZ()}, the conversion is done in these steps:
\itemize{
\item XYZ  \rarrow  linear RGB using the 3x3 matrix for the given \code{space} and \code{which}
\item if \code{TF} is not the identity, the linear RGBs are clamped to [0,1]\eqn{^3} if necessary
\item linear RGB  \rarrow  signal RGB using \code{SignalRGBfromLinearRGB()} and all other the given arguments
}

In \code{RGBfromLab()}, Lab \rarrow XYZ
is calculated using
\code{\link[spacesXYZ:toXYZ]{spacesXYZ::XYZfromLab}()},
with the white point
(either \code{'scene'} or \code{'display'}) of the given RGB space.

}

\references{
Wikipedia. \bold{RGB color space}.
\url{https://en.wikipedia.org/wiki/RGB_color_space}
}


\seealso{
\code{\link{XYZfromRGB}()},
\code{\link{LinearRGBfromSignalRGB}()},
\code{\link{installRGB}()},
\code{\link{identity.TF}},
\code{\link[spacesXYZ:toXYZ]{spacesXYZ::XYZfromLab}()}
}

\examples{
RGBfromXYZ( c(80.310897,90.306510,84.613450, 100,100,100)/100, max=255 )
##       RGB.R    RGB.G    RGB.B OutOfGamut
##  1 230.1676 249.4122 225.2472      FALSE
##  2 255.0000 249.1125 244.4704       TRUE
}

\keyword{RGB}

