% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpc.R
\name{gpc}
\alias{gpc}
\alias{gpc,sf-method}
\alias{gpc,SpatRaster-method}
\title{geographical pattern causality}
\usage{
\S4method{gpc}{sf}(
  data,
  cause,
  effect,
  libsizes = NULL,
  E = 3,
  k = E + 2,
  tau = 1,
  style = 1,
  lib = NULL,
  pred = NULL,
  boot = 99,
  random = TRUE,
  seed = 42L,
  dist.metric = "L2",
  zero.tolerance = k,
  relative = TRUE,
  weighted = TRUE,
  threads = detectThreads(),
  detrend = FALSE,
  parallel.level = "low",
  bidirectional = TRUE,
  progressbar = TRUE,
  nb = NULL
)

\S4method{gpc}{SpatRaster}(
  data,
  cause,
  effect,
  libsizes = NULL,
  E = 3,
  k = E + 2,
  tau = 1,
  style = 1,
  lib = NULL,
  pred = NULL,
  boot = 99,
  random = TRUE,
  seed = 42L,
  dist.metric = "L2",
  zero.tolerance = k,
  relative = TRUE,
  weighted = TRUE,
  threads = detectThreads(),
  detrend = FALSE,
  parallel.level = "low",
  bidirectional = TRUE,
  progressbar = TRUE,
  grid.coord = TRUE
)
}
\arguments{
\item{data}{observation data.}

\item{cause}{name of causal variable.}

\item{effect}{name of effect variable.}

\item{libsizes}{(optional) number of spatial units used (input needed: \code{vector} - spatial vector, \code{matrix} - spatial raster).}

\item{E}{(optional) embedding dimensions.}

\item{k}{(optional) number of nearest neighbors.}

\item{tau}{(optional) step of spatial lags.}

\item{style}{(optional) embedding style (\code{0} includes current state, \code{1} excludes it).}

\item{lib}{(optional) libraries indices (input requirement same as \code{libsizes}).}

\item{pred}{(optional) predictions indices (input requirement same as \code{libsizes}).}

\item{boot}{(optional) number of bootstraps to perform.}

\item{random}{(optional) whether to use random sampling.}

\item{seed}{(optional) random seed.}

\item{dist.metric}{(optional) distance metric (\code{L1}: Manhattan, \code{L2}: Euclidean).}

\item{zero.tolerance}{(optional) maximum number of zeros tolerated in signature space.}

\item{relative}{(optional) whether to calculate relative changes in embeddings.}

\item{weighted}{(optional) whether to weight causal strength.}

\item{threads}{(optional) number of threads to use.}

\item{detrend}{(optional) whether to remove the linear trend.}

\item{parallel.level}{(optional) level of parallelism, \code{low} or \code{high}.}

\item{bidirectional}{(optional) whether to examine bidirectional causality.}

\item{progressbar}{(optional) whether to show the progress bar.}

\item{nb}{(optional) neighbours list.}

\item{grid.coord}{(optional) whether to detrend using cell center coordinates (\code{TRUE}) or row/column numbers (\code{FALSE}).}
}
\value{
A list
\describe{
\item{\code{xmap}}{cross mapping results (only present if \code{libsizes} is not \code{NULL})}
\item{\code{causality}}{per-sample causality statistics (present if \code{libsizes} is \code{NULL})}
\item{\code{summary}}{overall causal strength (present if \code{libsizes} is \code{NULL})}
\item{\code{pattern}}{pairwise pattern relationships (present if \code{libsizes} is \code{NULL})}
\item{\code{varname}}{names of causal and effect variables}
\item{\code{bidirectional}}{whether to examine bidirectional causality}
}
}
\description{
geographical pattern causality
}
\examples{
columbus = sf::read_sf(system.file("case/columbus.gpkg",package="spEDM"))
\donttest{
gpc(columbus,"hoval","crime",E = 6,k = 9)

# convergence diagnostics
g = gpc(columbus,"hoval","crime",libsizes = seq(5,45,5),E = 6,k = 9)
plot(g)
}
}
\references{
Zhang, Z., Wang, J., 2025. A model to identify causality for geographic patterns. International Journal of Geographical Information Science 1–21.
}
