% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modulationSpectrum.R
\name{getRough}
\alias{getRough}
\title{Get roughness}
\usage{
getRough(m, roughRange)
}
\arguments{
\item{m}{numeric matrix of non-negative values with colnames giving temporal
modulation frequency}

\item{roughRange}{range of temporal modulation frequencies corresponding to
roughness}
}
\value{
Returns roughness in percent.
}
\description{
Internal soundgen function
}
\details{
Helper function for calculating roughness - the proportion of energy /
amplitude in the roughness range
}
\examples{
m = modulationSpectrum(soundgen(), samplingRate = 16000)$original
soundgen:::getRough(m, roughRange = c(30, Inf))
}
\keyword{internal}
