% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_analyze.R
\name{getPrior}
\alias{getPrior}
\title{Get prior for pitch candidates}
\usage{
getPrior(priorMean, priorSD, pitchCands = NULL, pitchFloor = 75,
  pitchCeiling = 3000, plot = FALSE)
}
\arguments{
\item{priorMean}{specifies the mean (Hz) and standard deviation
(semitones) of gamma distribution describing our prior knowledge about the
most likely pitch values for this file. For ex., \code{priorMean = 300,
priorSD = 6} gives a prior with mean = 300 Hz and SD = 6 semitones (half
an octave)}

\item{priorSD}{specifies the mean (Hz) and standard deviation
(semitones) of gamma distribution describing our prior knowledge about the
most likely pitch values for this file. For ex., \code{priorMean = 300,
priorSD = 6} gives a prior with mean = 300 Hz and SD = 6 semitones (half
an octave)}

\item{pitchCands}{a matrix of pitch candidate frequencies}

\item{pitchFloor}{absolute bounds for pitch candidates (Hz)}

\item{pitchCeiling}{absolute bounds for pitch candidates (Hz)}

\item{plot}{if TRUE, produces a separate plot of the prior}
}
\value{
Returns a numeric matrix of the same dimensions as pitchCands for
  multiplying the matrix of certainty of in pitch values.
}
\description{
Internal soundgen function.
}
\details{
Prior for adjusting the estimated pitch certainties. For ex., if primarily
working with speech, we could prioritize pitch candidates in the expected
pitch range (100-1000 Hz) and dampen candidates with very high or very low
frequency as unlikely but still remotely possible in everyday vocalizing
contexts (think a soft pitch ceiling). Algorithm: the multiplier for each
pitch candidate is the density of gamma distribution with mean = priorMean
(Hz) and sd = priorSD (semitones) normalized so max = 1 over [pitchFloor,
pitchCeiling]. Called by analyze().
}
\examples{
soundgen:::getPrior(150, 2, pitchCands = NULL, plot = TRUE)
}
\keyword{internal}
