% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postprocessing.R
\name{playme}
\alias{playme}
\title{Play audio}
\usage{
playme(sound, samplingRate = 16000, player = NULL)
}
\arguments{
\item{sound}{a vector of numbers on any scale or a path to a .wav file}

\item{samplingRate}{sampling rate (only needed if sound is a vector)}

\item{player}{the name of player to use, eg "aplay", "play", "vlc", etc. In
case of errors, try setting another default player for
\code{\link[tuneR]{play}}}

\item{...}{additional parameters passed to \code{\link[tuneR]{play}}}
}
\description{
Plays an audio file or a numeric vector. This is a simple wrapper for the
functionality provided by \code{\link[tuneR]{play}}. Recommended players on
Linux: "play" from the "vox" library (default), "aplay".
}
\examples{
# Play an audio file:
# playme('pathToMyAudio/audio.wav')

# Create and play a numeric vector:
f0_Hz = 440
sound = sin(2 * pi * f0_Hz * (1:16000) / 16000)
# playme(sound, 16000)

# In case of errors, look into tuneR::play(). For ex., you might need to
# specify which player to use:
# playme(sound, 16000, player = 'aplay')

# To avoid doing it all the time, set the default player:
tuneR::setWavPlayer('aplay')
# playme(sound, 16000)  # should work without specifying the player
}
