% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{addSeparators}
\alias{addSeparators}
\title{Intersperse a vector of strings with a character or string.}
\usage{
addSeparators(x, separator = "|")
}
\arguments{
\item{x}{[character vector] The strings to be interspersed.}

\item{separator}{[character] The string with which to intersperse. Defaults to \code{"|"}.}
}
\value{
[character vector] A vector of interspersed strings.
}
\description{
Primarily intended to insert separators into a column of words, to facilitate manual segmentation and aligning.
}
\details{
Preparation of data for \code{\link{soundcorrs}} consists of segmentation and alignment. Segmentation can proceed on phoneme-by-phoneme, morpheme-by-morpheme, or any other basis; the only constraint is that each word in a pair/triple/... of words must contain the same number of segments. Segments are indicated by separators, by default the character \code{"|"}. The action of inserting separators, potentially between every two letters, in a large dataset, can become time consuming. \code{addSeparators} automates at least this part of the process.
}
\examples{
addSeparators (c("word","mot","focal"), ".")
}
