% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sortable_js.R
\name{sortable_js}
\alias{sortable_js}
\title{Creates an htmlwidget with embedded 'SortableJS' library.}
\usage{
sortable_js(
  css_id,
  options = sortable_options(),
  width = 0,
  height = 0,
  elementId = NULL,
  preRenderHook = NULL
)
}
\arguments{
\item{css_id}{\code{String} css_id id on which to apply \code{SortableJS}.  Note,
\code{sortable_js} works with any html element, not just \code{ul/li}.}

\item{options}{Options to be supplied to \link{sortable_js} object. See \link{sortable_options} for more details}

\item{width}{Fixed width for widget (in css units). The default is
\code{NULL}, which results in intelligent automatic sizing based on the
widget's container.}

\item{height}{Fixed height for widget (in css units). The default is
\code{NULL}, which results in intelligent automatic sizing based on the
widget's container.}

\item{elementId}{Use an explicit element ID for the widget (rather than an
automatically generated one). Useful if you have other JavaScript that
needs to explicitly discover and interact with a specific widget instance.}

\item{preRenderHook}{A function to be run on the widget, just prior to
rendering. It accepts the entire widget object as input, and should return
a modified widget object.}
}
\description{
Creates an \code{htmlwidget} that provides
\href{https://github.com/SortableJS/Sortable}{SortableJS} to use for
drag-and-drop interactivity in Shiny apps and R Markdown.
}
\examples{
## -- example-sortable-js -------------------------------------------------
# Simple example of sortable_js.
# Important: set the tags CSS `id` equal to the sortable_js `css_id`

if (interactive()) {
  if (require(htmltools)) {
    html_print(
      tagList(
        tags$p("You can drag and reorder the items in this list:"),
        tags$ul(
          id = "example_1",
          tags$li("Move"),
          tags$li("Or drag"),
          tags$li("Each of the items"),
          tags$li("To different positions")
        ),
        sortable_js(css_id = "example_1")
      )
    )
  }
}
}
\seealso{
\code{\link[=sortable_options]{sortable_options()}}
}
