% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audioblast.R
\name{audioblast}
\alias{audioblast}
\title{Get data or analyses from audioBlast}
\usage{
audioblast(
  type,
  name,
  endpoint = NULL,
  check = TRUE,
  max_pages = NULL,
  page = 1,
  quiet = FALSE,
  on.issue = stop,
  output = "data.frame",
  ...
)
}
\arguments{
\item{type}{One of data, analysis, standalone.}

\item{name}{Name of data or analysis source.}

\item{endpoint}{Optionally specify endpoint of an audioBlast module.}

\item{check}{Logical. Performs sanity check on input before sending to audioBLAST.}

\item{max_pages}{Maximum number of data pages to return, by default this is set to NULL and returns all pages.}

\item{page}{First page of results to request, defaults to 1.}

\item{quiet}{If true will not print progress. Silence is a virtue.}

\item{on.issue}{Function to call on error or warning. By default \code{stop} to raise
a standard R error. Setting to \code{warning} will instead a warning.}

\item{output}{By default a \code{data.frame}. "Annotations" will return a list of
\code{Annotation} objects.}

\item{...}{Fields and values to filter on. Any field defined by audioBLAST.}
}
\value{
A data frame
}
\description{
Search for data or analyses on audioBlast.
}
\examples{
\dontrun{
audioblast("data", "recordings", taxon="Gryllotalpa vineae")
}

}
