% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectraMaths.R
\name{addSpectra}
\alias{addSpectra}
\title{Add two spectra from seewave}
\usage{
addSpectra(s1, s2, coerceNegative = "no")
}
\arguments{
\item{s1}{First spectrum}

\item{s2}{Second spectrum}

\item{coerceNegative}{Sets any values below zero to zero, accepted values "input", "output" or "both".}
}
\value{
A spectrum of s1+s2
}
\description{
This function takes two spectra from seewave (or equivalent) and adds their values. The spectra must have
the same bins.
}
\examples{
\dontrun{
addSpectra(spec1, spec2)
addSpectra(spec1, spec2, coerceNegative="input")
}

}
