% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetchHenry.R
\name{summarizeSoilTemperature}
\alias{summarizeSoilTemperature}
\alias{month2season}
\alias{fetchHenry}
\title{Get data from Henry Mount Soil Temperature and Water Database}
\usage{
summarizeSoilTemperature(soiltemp.data)

month2season(x)

fetchHenry(
  what = "all",
  usersiteid = NULL,
  project = NULL,
  sso = NULL,
  gran = "day",
  start.date = NULL,
  stop.date = NULL,
  pad.missing.days = TRUE,
  soiltemp.summaries = TRUE,
  tz = ""
)
}
\arguments{
\item{soiltemp.data}{A \code{data.frame} containing soil temperature data}

\item{x}{character vector containing month abbreviation e.g. \code{c('Jun', 'Dec', 'Sep')}}

\item{what}{type of data to return: 'sensors': sensor metadata only |
'soiltemp': sensor metadata + soil temperature data | 'soilVWC': sensor
metadata + soil moisture data | 'airtemp': sensor metadata + air temperature
data | 'waterlevel': sensor metadata + water level data |'all': sensor
metadata + all sensor data}

\item{usersiteid}{(optional) filter results using a NASIS user site ID}

\item{project}{(optional) filter results using a project ID}

\item{sso}{(optional) filter results using a soil survey office code}

\item{gran}{data granularity: "hour" (if available), "day", "week", "month", "year"; returned data
are averages}

\item{start.date}{(optional) starting date filter}

\item{stop.date}{(optional) ending date filter}

\item{pad.missing.days}{should missing data ("day" granularity) be filled
with NA? see details}

\item{soiltemp.summaries}{should soil temperature ("day" granularity only)
be summarized? see details}

\item{tz}{Used for custom timezone. Default \code{""} is current locale}
}
\value{
a list containing: \item{sensors}{a \code{sf} \code{data.frame}
object containing site-level information} \item{soiltemp}{a
\code{data.frame} object containing soil temperature timeseries data}
\item{soilVWC}{a \code{data.frame} object containing soil moisture
timeseries data} \item{airtemp}{a \code{data.frame} object containing air
temperature timeseries data} \item{waterlevel}{a \code{data.frame} object
containing water level timeseries data}
}
\description{
This function is a front-end to the REST query functionality of the Henry
Mount Soil Temperature and Water Database.
}
\details{
Filling missing days with NA is useful for computing and index of how
complete the data are, and for estimating (mostly) unbiased MAST and
seasonal mean soil temperatures. Summaries are computed by first averaging
over Julian day, then averaging over all days of the year (MAST) or just
those days that occur within "summer" or "winter". This approach makes it
possible to estimate summaries in the presence of missing data. The quality
of summaries should be weighted by the number of "functional years" (number
of years with non-missing data after combining data by Julian day) and
"complete years" (number of years of data with >= 365 days of non-missing
data).

See:
\itemize{
\item \href{http://soilmap2-1.lawr.ucdavis.edu/henry/}{Henry Mount Soil Climate Database}
\item \href{http://ncss-tech.github.io/AQP/soilDB/Henry-demo.html}{\code{fetchHenry} Tutorial}
}
}
\note{
This function and the back-end database are very much a work in
progress.
}
\seealso{
\code{\link{fetchSCAN}}
}
\author{
D.E. Beaudette
}
\keyword{manip}
