% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.R
\name{update-version}
\alias{update-version}
\alias{increment_major}
\alias{increment_major.smvr}
\alias{increment_minor}
\alias{increment_minor.smvr}
\alias{increment_patch}
\alias{increment_patch.smvr}
\alias{mark_as_pre_release}
\alias{mark_as_pre_release.smvr}
\alias{add_build_metadata}
\alias{add_build_metadata.smvr}
\title{Update version components}
\usage{
increment_major(x, ...)

\method{increment_major}{smvr}(x, ...)

increment_minor(x, ...)

\method{increment_minor}{smvr}(x, ...)

increment_patch(x, ...)

\method{increment_patch}{smvr}(x, ...)

mark_as_pre_release(x, ...)

\method{mark_as_pre_release}{smvr}(x, ids, ...)

add_build_metadata(x, ...)

\method{add_build_metadata}{smvr}(x, metadata = "", ...)
}
\arguments{
\item{x}{An version object}

\item{...}{Additional arguments passed to methods.}

\item{ids}{Something can be cast to \link{pre_release_ids} representing the
pre-release identifiers, length must be 1 or the same as \code{x}.}

\item{metadata}{A character vector of build metadata,
length must be 1 or the same as \code{x}.}
}
\value{
An updated version object with the specified changes applied.
}
\description{
These functions allows to update the components of version objects.
\itemize{
\item \code{increment_major()}, \code{increment_minor()}, and \code{increment_patch()} update
the major, minor, and patch version numbers respectively.
Note that these functions reset the pre-release and build metadata to empty.
\item \code{mark_as_pre_release()} marks the version as a pre-release version.
\item \code{add_build_metadata()} adds build metadata to the version.
}
}
\examples{
v <- parse_semver(c("0.9.9", "1.0.0-a.1", "1.1.0+1"))

increment_major(v)
increment_minor(v)
increment_patch(v)
mark_as_pre_release(v, ids = "rc.1")
add_build_metadata(v, metadata = "build.1")
}
