% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brent.R
\name{brentMin}
\alias{brentMin}
\title{Brent's local minimisation}
\usage{
brentMin(
  f,
  interval,
  lower = NA_real_,
  upper = NA_real_,
  tol = 1e-08,
  maxiter = 200L,
  trace = 0L
)
}
\arguments{
\item{f}{A function to be minimised on an interval.}

\item{interval}{A length-2 vector containing the end-points of the search interval.}

\item{lower}{Scalar: the lower end point of the search interval. Not necessary if \code{interval} is provided.}

\item{upper}{Scalar: the upper end point of the search interval. Not necessary if \code{interval} is provided.}

\item{tol}{Small positive scalar: stopping criterion. The search stops when the
distance between the current candidate and the midpoint of the bracket is smaller than
the dynamic threshold \code{2 * (sqrt(DBL_EPSILON) * abs(x) + tol)}}

\item{maxiter}{Positive integer: the maximum number of iterations.}

\item{trace}{Integer: 0, 1, or 2. Amount of tracing information on the optimisation progress
printed. \code{trace = 0} produces no output, \code{trace = 1} reports the starting
and final results, and \code{trace = 2} provides detailed iteration-level output.}
}
\value{
A list with the following elements:
\describe{
  \item{root}{Location of the minimum.}
  \item{f.root}{Function value at the minimuim location.}
  \item{iter}{Total iteration count used.}
  \item{estim.prec}{Estimate of the final bracket size.}
}
}
\description{
Brent's local minimisation
}
\details{
This is an adaptation of the implementation by John Burkardt (currently available at
[https://people.math.sc.edu/Burkardt/m_src/brent/brent.html](https://people.math.sc.edu/Burkardt/m_src/brent/brent.html)).

This function is similar to \code{local_min} or \code{R_zeroin2}-style logic, but with the
following additions: the number of iterations is tracked, and the algorithm stops when the
standard Brent criterion is met or if the maximum iteration count is reached.
The code stores the approximate final bracket width in \code{estim.prec}, like in [uniroot()].
If the minimiser is pinned to an end point, \code{estim.prec = NA}.

There are no preliminary iterations, unlike [brentZero()].

TODO: add preliminary iterations.
}
\examples{
f <- function (x) (x - 1/3)^2
brentMin(f, c(0, 1), tol = 0.0001)
brentMin(function(x) x^2*(x-1), lower = 0, upper = 10, trace = 1)
}
