% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{multicov}
\alias{multicov}
\alias{multicov.smooth}
\title{Function returns the multiple steps ahead covariance matrix of forecast errors}
\usage{
multicov(object, type = c("analytical", "empirical", "simulated"), h = 10,
  nsim = 1000, ...)

\method{multicov}{smooth}(object, type = c("analytical", "empirical",
  "simulated"), h = 10, nsim = 1000, ...)
}
\arguments{
\item{object}{Model estimated using one of the functions of smooth package.}

\item{type}{What method to use in order to produce covariance matrix:
\enumerate{
\item \code{analytical} - based on the state space structure of the model and the
one-step-ahead forecast error. This works for pure additive and pure multiplicative
models. The values for the mixed models might be off.
\item \code{empirical} - based on the in-sample 1 to h steps ahead forecast errors
(works fine on larger samples);
\item \code{simulated} - the data is simulated from the estimated model, then the
same model is applied to it and then the empirical 1 to h steps ahead forecast
errors are produced;
}}

\item{h}{Forecast horizon to use in the calculations.}

\item{nsim}{Number of iterations to produce in the simulation. Only needed if
\code{type="simulated"}}

\item{...}{Other parameters passed to simulate function (if \code{type="simulated"}
is used). These are \code{obs} and \code{seed}. By default \code{obs=1000}.
This approach increases the accuracy of covariance matrix on small samples
and intermittent data;}
}
\value{
Scalar in cases of non-smooth functions. (h x h) matrix otherwise.
}
\description{
This function extracts covariance matrix of 1 to h steps ahead forecast errors for
\code{adam()}, \code{ssarima()}, \code{gum()}, \code{sma()}, \code{es()} and
\code{ces()} models.
}
\details{
The function returns either scalar (if it is a non-smooth model)
or the matrix of (h x h) size with variances and covariances of 1 to h steps ahead
forecast errors.
}
\examples{

x <- rnorm(100,0,1)

# A simple example with a 5x5 covariance matrix
ourModel <- ces(x, h=5)
multicov(ourModel)

}
\seealso{
\link[smooth]{orders}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.com}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{ts}
\keyword{univar}
