% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adam.R
\name{reapply}
\alias{reapply}
\alias{reforecast}
\title{Reapply the model with randomly generated initial parameters and produce forecasts}
\usage{
reapply(object, nsim = 1000, bootstrap = FALSE, ...)

reforecast(object, h = 10, newdata = NULL, occurrence = NULL,
  interval = c("prediction", "confidence", "none"), level = 0.95,
  side = c("both", "upper", "lower"), cumulative = FALSE, nsim = 100,
  ...)
}
\arguments{
\item{object}{Model estimated using one of the functions of smooth package.}

\item{nsim}{Number of paths to generate (number of simulations to do).}

\item{bootstrap}{The logical, which determines, whether to use bootstrap for the
covariance matrix of parameters or not.}

\item{...}{Other parameters passed to \code{mean()} function in case of
\code{reforecast} (this mainly refers to \code{trim} variable, which is set to
0.01 by default) and to \code{vcov} in case of \code{reapply}.}

\item{h}{Forecast horizon.}

\item{newdata}{The new data needed in order to produce forecasts.}

\item{occurrence}{The vector containing the future occurrence variable
(values in [0,1]), if it is known.}

\item{interval}{What type of mechanism to use for interval construction. The options
include \code{interval="none"}, \code{interval="prediction"} (prediction intervals)
and \code{interval="confidence"} (intervals for the point forecast). The other options
are not supported and do not make much sense for the refitted model.}

\item{level}{Confidence level. Defines width of prediction interval.}

\item{side}{Defines, whether to provide \code{"both"} sides of prediction
interval or only \code{"upper"}, or \code{"lower"}.}

\item{cumulative}{If \code{TRUE}, then the cumulative forecast and prediction
interval are produced instead of the normal ones. This is useful for
inventory control systems.}
}
\value{
\code{reapply()} returns object of the class "reapply", which contains:
\itemize{
\item \code{timeElapsed} - Time elapsed for the code execution;
\item \code{y} - The actual values;
\item \code{states} - The array of states of the model;
\item \code{refitted} - The matrix with fitted values, where columns correspond
to different paths;
\item \code{fitted} - The vector of fitted values (conditional mean);
\item \code{model} - The name of the constructed model;
\item \code{transition} - The array of transition matrices;
\item \code{measurement} - The array of measurement matrices;
\item \code{persistence} - The matrix of persistence vectors (paths in columns);
\item \code{profile} - The array of profiles obtained by the end of each fit.
}

\code{reforecast()} returns the object of the class \link[smooth]{forecast.smooth},
which contains in addition to the standard list the variable \code{paths} - all
simulated trajectories with h in rows, simulated future paths for each state in
columns and different states (obtained from \code{reapply()} function) in the
third dimension.
}
\description{
\code{reapply} function generates the parameters based on the values in the provided
object and then reapplies the same model with those parameters to the data, getting
the fitted paths and updated states. \code{reforecast} function uses those values
in order to produce forecasts for the \code{h} steps ahead.
}
\details{
The main motivation of the function is to take the randomness due to the in-sample
estimation of parameters into account when fitting the model and to propagate
this randomness to the forecasts. The methods can be considered as a special case
of recursive bootstrap.
}
\examples{

x <- rnorm(100,0,1)

# Just as example. orders and lags do not return anything for ces() and es(). But modelType() does.
ourModel <- adam(x, "ANN")
refittedModel <- reapply(ourModel, nsim=50)
plot(refittedModel)

ourForecast <- reforecast(ourModel, nsim=50)

}
\seealso{
\link[smooth]{forecast.smooth}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.ru}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{ts}
\keyword{univar}
