% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot3D.R
\name{plot3D}
\alias{plot3D}
\title{Surface plot of two-dimensional test function.}
\usage{
plot3D(x, length.out = 100L, ...)
}
\arguments{
\item{x}{[\code{smoof_function}]\cr
Two-dimensional snoof function.}

\item{length.out}{[\code{integer(1)}]\cr
Determines the \dQuote{smoothness} of the grid. The higher the value, the
smoother the function landscape looks like. However, you should avoid setting
this parameter to high, since with the \code{contour} option set to \code{TRUE}
the drawing can take quite a lot of time. Default is \code{100}.}

\item{...}{[any]\cr
Furhter parameters passed to \code{\link[plot3D]{persp3D}}.}
}
\description{
Surface plot of two-dimensional test function.
}
\examples{
library(plot3D)
fn = makeRastriginFunction(dimensions = 2L)
\dontrun{
plot3D(fn)
plot3D(fn, contour = TRUE)
plot3D(fn, image = TRUE, phi = 30)
}
}

