% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{tapmat_cov}
\alias{tapmat_cov}
\title{Tappered Matern covariance function for a given distance matrix.}
\usage{
tapmat_cov(dists, sigsq, phi, nu, theta)
}
\arguments{
\item{dists}{a numeric matrix representing the distance between spatial
entities.}

\item{sigsq}{the \eqn{\sigma^2} parameter from the Matern covariance
function.}

\item{phi}{the \eqn{\phi} parameter from the Matern covariance function,'}

\item{nu}{smoothness parameter}

\item{theta}{\eqn{\theta} taper range.}
}
\value{
The tappered matern covariance function (for a stationary and isotropic
process) associated with the provided distances (\code{dists}) and the
given set of parameters.
}
\description{
Computing the tappered Matern covariance function for a matrix
of
distances.
}
\keyword{internal}
