% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elliptic.test2.R
\name{elliptic.test}
\alias{elliptic.test}
\title{Elliptical Spatial Scan Test}
\usage{
elliptic.test(
  coords,
  cases,
  pop,
  ex = sum(cases)/sum(pop) * pop,
  nsim = 499,
  alpha = 0.1,
  ubpop = 0.5,
  shape = c(1, 1.5, 2, 3, 4, 5),
  nangle = c(1, 4, 6, 9, 12, 15),
  a = 0.5,
  cl = NULL,
  type = "poisson",
  min.cases = 2
)
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid
coordinates for the regions in the form (x, y) or
(longitude, latitude) is using great circle distance.}

\item{cases}{The number of cases observed in each region.}

\item{pop}{The population size associated with each
region.}

\item{ex}{The expected number of cases for each region.
The default is calculated under the constant risk
hypothesis.}

\item{nsim}{The number of simulations from which to
compute the p-value.}

\item{alpha}{The significance level to determine whether
a cluster is signficant.  Default is 0.10.}

\item{ubpop}{The upperbound of the proportion of the
total population to consider for a cluster.}

\item{shape}{The ratios of the major and minor axes of
the desired ellipses.}

\item{nangle}{The number of angles (between 0 and 180) to
consider for each shape.}

\item{a}{The penalty for the spatial scan statistic.  The
default is 0.5.}

\item{cl}{
A cluster object created by \code{\link{makeCluster}},
or an integer to indicate number of child-processes
(integer values are ignored on Windows) for parallel evaluations
(see Details on performance).
}

\item{type}{The type of scan statistic to compute. The
default is \code{"poisson"}. The other choice
is \code{"binomial"}.}

\item{min.cases}{The minimum number of cases required for
a cluster.  The default is 2.}
}
\value{
Returns a \code{smerc_cluster} object.
}
\description{
\code{elliptic.test} performs the elliptical scan test of
Kulldorf et al. (2006).
}
\details{
The test is performed using the spatial scan test based
on the Poisson test statistic and a fixed number of
cases.  Candidate zones are elliptical and extend from the
observed data locations.  The clusters returned are
non-overlapping, ordered from most significant to least
significant.  The first cluster is the most likely to
be a cluster.  If no significant clusters are found, then
the most likely cluster is returned (along with a
warning).
}
\examples{
data(nydf)
coords <- nydf[, c("x", "y")]
\dontrun{
# run only a small number of sims to make example fast
out <- elliptic.test(
  coords = coords,
  cases = floor(nydf$cases),
  pop = nydf$pop, ubpop = 0.1,
  nsim = 19,
  alpha = 0.12)
}
}
\references{
Kulldorff, M. (1997) A spatial scan
  statistic. Communications in Statistics - Theory and
  Methods, 26(6): 1481-1496,
  <doi:10.1080/03610929708831995>

Kulldorff, M., Huang, L., Pickle,
L. and Duczmal, L. (2006) An elliptic spatial scan
statistic. Statististics in Medicine, 25:3929-3943.
<doi:10.1002/sim.2490>
}
\seealso{
\code{\link{print.smerc_cluster}},
\code{\link{summary.smerc_cluster}},
\code{\link{plot.smerc_cluster}},
\code{\link{scan.stat}}, \code{\link{scan.test}}
}
\author{
Joshua French
}
