% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers.R
\name{clean_outliers}
\alias{clean_outliers}
\title{Outliers cleaning wrapper}
\usage{
clean_outliers(dataset, method, ...)
}
\arguments{
\item{dataset}{we want to clean outliers of}

\item{method}{selected method to clean outliers. Possibilities are: \itemize{
\item{"univariate"}{ detects outliers column by column (an outlier will be
an abnormal value inside a column) and fills them with mean or median of
the corresponding column} \item{"multivariate"}{ detects outliers using a
multicolumn approach, so that an outlier will be a whole observation (row).
And deletes those observations} }}

\item{...}{further arguments for the method}
}
\value{
The treated dataset (either with outliers replaced or erased)
}
\description{
Outliers cleaning wrapper
}
\examples{
library("smartdata")

super_iris <- clean_outliers(iris, method = "multivariate", type = "adj")
super_iris <- clean_outliers(iris, method = "multivariate", type = "quan")

# Use mean as method to substitute outliers
super_iris <- clean_outliers(iris, method = "univariate", type = "z", prob = 0.9, fill = "mean")
# Use median as method to substitute outliers
super_iris <- clean_outliers(iris, method = "univariate", type = "z", prob = 0.9, fill = "median")
# Use chi-sq instead of z p-values
super_iris <- clean_outliers(iris, method = "univariate", type = "chisq",
                             prob = 0.9, fill = "median")
# Use interquartilic range instead (lim argument is mandatory when using it)
super_iris <- clean_outliers(iris, method = "univariate", type = "iqr", lim = 0.9, fill = "median")

}
