%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file was automatically generated by Rdoc on 2001-04-20 20:27:18.
% Do NOT modify this file, instead modify the source (sma/R/Rplot.R).
% Rdoc is copyright (C) 2001, Henrik Bengtsson, henrikb@braju.com.
% Download the Rdoc compiler at http://www.braju.com/R/
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

\name{plot.svb}

\alias{plot.svb}
\alias{svb.func}

\title{Plot of Signal vs. Background}

\description{
Produces a scatter plot of background corrected signal intensities
and background intensities.
}

\usage{
plot.svb(x, channel="R", image.id=1, S.isbgcor=F, ...)
}

\arguments{
  \item{x}{a numeric list of signal and background intensities, can
  be raw or background corrected data.}   

 \item{channel}{the specific channel to which the intensities to be
   considered, correspond to, that is, either red or green. The default
   channel is red.}

 \item{image.id}{integer value; the index of the slide which is considered}

 \item{S.isbgcor}{logical flag, equal to TRUE if the signal intensities in
   x contain background corrected signal intensities instead of raw
   signal intensities. By default this is set to FALSE.}

 \item{\dots}{graphical parameters may also be supplied as arguments
 to the function (see \code{\link{par}}).} 

}

\value{a plot is created on the current graphics device.}

\author{
  Yee Hwa Yang, \email{yeehwa@stat.berkeley.edu} \cr
  Sandrine Dudoit, \email{sandrine@stat.berkeley.edu} \cr
  Jessica Mar}
}
  \seealso{\code{\link{plot}}.} 

\examples{
data(MouseArray)
# mouse.setup <- init.grid()
# mouse.data <- init.data() ## see \emph{init.data}

plot.svb(mouse.data, "green", 3) 
## thiscreates a plot of the signal versus background intensities 
## for the green channel, using data collected from the third slide. 
}

\keyword{hplot}

%\keyword{microarray, background}

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% End of File
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
