% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docker.R
\name{slurmr_docker}
\alias{slurmr_docker}
\alias{docker_available}
\alias{slurmr_docker_pull}
\alias{slurmr_docker_run}
\alias{slurmr_docker_stop}
\title{slurmR docker image}
\usage{
docker_available(path = "")

slurmr_docker_pull(path = "")

slurmr_docker_run(path = "", pull = TRUE, timeout = 60)

slurmr_docker_stop(UUID = "", path = "")
}
\arguments{
\item{path}{Path to the \code{docker} executable. If not specified, the function
will try to figure it out by itself.}

\item{pull}{Logical scalar. When \code{TRUE}, if not available, it will
invoke \verb{docker pull}.}

\item{timeout}{Integer. Number of seconds to wait for docker to start
the slurmR image.}

\item{UUID}{String. Universally Unique Identifier.}
}
\description{
Helper functions to use \code{slurmR}'s docker image. This requires
having an internet connection and \code{docker} installed in your
system.
}
\details{
Starting version 0.5-0, a Docker image with Slurm, R, and slurmR
is available at \url{https://hub.docker.com/r/uscbiostats/slurmr}.
The source code (Dockerfile) is available in the project GitHub
repository: \url{https://github.com/USCbiostats/slurmR}.
}
\examples{
# This example requires having Docker installed in the system
\dontrun{
  # Start the docker image. By default it will try to pull the
  # image from Docker Hub if available

  # This opens a bash session with R + Slurm + slurmR
  slurmr_docker_run() 

  # Will pull the docker image
  slurmr_docker_pull()


}

}
