% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_user_weekly_players.R
\name{plot_user_weekly_players}
\alias{plot_user_weekly_players}
\title{Plot User Weekly Players}
\usage{
plot_user_weekly_players(
  league_id,
  display_name,
  title = paste0("<b>", display_name, ": Player Points by Week</b>"),
  tick_color = "inherit"
)
}
\arguments{
\item{league_id}{League ID assigned by Sleeper (numeric).}

\item{display_name}{Display name created by user (string).}

\item{title}{Title for plot, which can include HTML formatting (string).}

\item{tick_color}{Font color, name or hex, for players (string).}
}
\value{
Returns a plot containing the display name's weekly players
        and their respective points for each week.
}
\description{
Given the league ID and display name, plot the total points scored by
week for each player ever associated with the display name.
}
\examples{
\dontrun{plot_user_weekly_players(688281863499907072, "datcommish")}

}
\author{
Nick Bultman, \email{njbultman74@gmail.com}, May 2024
}
\keyword{league}
\keyword{matchups}
\keyword{players}
\keyword{user}
\keyword{weekly}
