% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{gss7677}
\alias{gss7677}
\title{GSS 1976-1977 Data on Social Status and Tolerance towards Minorities}
\format{
A data frame with 2942 rows and 14 variables:
\describe{
\item{\code{YEAR}}{Interview year (1976, 1977).}
\item{\code{COHORT}}{Respondent's age cohort.\cr Levels: (1) \code{YOUNG}, (2) \code{YOUNG-MIDDLE}, (4) \code{MIDDLE}, (5) \code{OLD}.}
\item{\code{SEX}}{Respondent's sex.\cr Levels: (1) \code{MALE}, (2) \code{FEMALE}.}
\item{\code{RACE}}{Respondent's race.\cr Levels: (1) \code{WHITE}, (2) \code{BLACK}, (3) \code{OTHER}.}
\item{\code{DEGREE}}{Respondent's education level.\cr Levels: (1) \code{LT HS}, (2) \code{HIGH-SCH}, (3) \code{HIGHER}.}
\item{\code{REALRINC}}{Respondent's income.}
\item{\code{PAPRES}}{Father's occupational prestige.\cr Levels: (1) \code{LOW}, (2) \code{MEDIUM}, (3) \code{HIGH}.}
\item{\code{PADEG}}{Father's education level.\cr Levels: (1) \code{LT HS}, (2) \code{HIGH-SCH}, (3) \code{COLLEGE}, (4) \code{BACHELOR}, (5) \code{GRADUATE}.}
\item{\code{MADEG}}{Mother's education level.\cr Levels: (1) \code{LT HS}, (2) \code{HIGH-SCH}, (3) \code{COLLEGE}, (4) \code{BACHELOR}, (5) \code{GRADUATE}.}
\item{\code{TOLRAC}}{Tolerance towards racists.}
\item{\code{TOLCOM}}{Tolerance towards communists.}
\item{\code{TOLHOMO}}{Tolerance towards homosexuals.}
\item{\code{TOLATH}}{Tolerance towards atheists.}
\item{\code{TOLMIL}}{Tolerance towards militarists.}
}
}
\source{
General Social Survey (GSS) 1976, 1977
}
\usage{
gss7677
}
\description{
This dataset contains responses from the General Social Survey (GSS) for the years 1976 and 1977, focusing on social status and tolerance towards minorities.
The dataset can be used to replicate the analyses conducted in McCutcheon (1985) and Bakk et al. (2014). \cr
It includes covariates such as interview year, age, sex, race, education level, and income. Social status-related variables include father's occupation and education level, as well as mother's education level. Tolerance towards minorities is measured by agreement with three questions: (1) allowing public speaking, (2) allowing teaching, and (3) allowing literature publication.
}
\examples{
library(magrittr)
gss500 <- gss7677[1:500,] \%>\% na.omit
model_stat <- slca(status(3) ~ PAPRES + PADEG + MADEG) \%>\%
   estimate(data = gss500, control = list(em.tol = 1e-6))
summary(model_stat)
param(model_stat)

model_tol <- slca(tol(4) ~ TOLRAC + TOLCOM + TOLHOMO + TOLATH + TOLMIL) \%>\%
   estimate(data = gss500, control = list(em.tol = 1e-6))
summary(model_tol)
param(model_tol)

model_lta <- slca(
   status(3) ~ PAPRES + PADEG + MADEG,
   tol(4) ~ TOLRAC + TOLCOM + TOLHOMO + TOLATH + TOLMIL,
   status ~ tol
) \%>\% estimate(data = gss500, control = list(em.tol = 1e-6))
summary(model_lta)
param(model_lta)

\donttest{
regress(model_lta, status ~ SEX, gss500)
regress(model_lta, status ~ SEX, gss500, method = "BCH")
regress(model_lta, status ~ SEX, gss500, method = "ML")
}
}
\references{
Bakk Z, Kuha J. (2021) Relating latent class membership to external variables: An overview. Br J Math Stat Psychol. 74(2):340-362.

McCutcheon, A. L. (1985). A latent class analysis of tolerance for nonconformity in the American public. Public Opinion Quarterly, 49, 474–488.
}
\keyword{datasets}
