% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostic.R
\name{compare}
\alias{compare}
\title{Compare Two Estimated \code{slca} Models}
\usage{
compare(
  model1,
  model2,
  test = c("none", "chisq", "boot"),
  nboot = 50,
  method = c("hybrid", "em", "nlm"),
  plot = FALSE,
  maxiter = 1000,
  tol = 1e-08,
  verbose = FALSE
)
}
\arguments{
\item{model1}{an object of class \code{slca} and \code{estimated}.}

\item{model2}{another object of class \code{slca} and \code{estimated}.}

\item{test}{a character string specifying the type of test to be conducted. If \code{"chisq"}, a chi-squared test is conducted. If \code{"boot"}, a bootstrap test is conducted.}

\item{nboot}{an integer specifying the number of bootstrap rounds to be performed.}

\item{method}{estimation method for bootstrapping.}

\item{plot}{a logical value indicating whether to print histogram of G-squared statistics for boostrap samples, only for \code{test = "boot"}.}

\item{maxiter}{an integer specifying maximum number of iterations allowed for the estimation process of each bootstrapping round.}

\item{tol}{a numeric value setting tolerance for the convergence of each bootstrapping round.}

\item{verbose}{a logical value indicating whether to print progress updates on the number of bootstrapping rounds completed.}
}
\value{
A \code{data.frame} containing the number of parameters (Df), loglikelihood, AIC, BIC, G-squared statistics, and the residual degree of freedom for each object.
Depending on the \code{test} argument, the p-value for the corresponding statistical test may also be included.
}
\description{
Provides relative model fit test for two fitted SLCM models with deviance statistic.
}
\examples{
library(magrittr)
data <- gss7677[gss7677$COHORT == "YOUNG", ]
stat2 <- slca(status(2) ~ PAPRES + PADEG + MADEG) \%>\%
   estimate(data = data, control = list(verbose = FALSE))
stat3 <- slca(status(3) ~ PAPRES + PADEG + MADEG) \%>\%
   estimate(data = data, control = list(verbose = FALSE))
stat4 <- slca(status(4) ~ PAPRES + PADEG + MADEG) \%>\%
   estimate(data = data, control = list(verbose = FALSE))

gof(stat2, stat3, stat4)
gof(stat2, stat3, stat4, test = "chisq")
\donttest{
gof(stat2, stat3, stat4, test = "boot")
}

compare(stat3, stat4)
compare(stat3, stat4, test = "chisq")
\donttest{
compare(stat3, stat4, test = "boot")
}
}
\seealso{
\link[slca]{gof}
}
