% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slanter.R
\name{reorder_hclust}
\alias{reorder_hclust}
\title{Given a clustering of some data, and some ideal order we'd like to use to visualize it, reorder
(but do not modify) the clustering to be as consistent as possible with this ideal order.}
\usage{
reorder_hclust(clusters, order)
}
\arguments{
\item{clusters}{The existing clustering of the data.}

\item{order}{The ideal order we'd like to see the data in.}
}
\value{
A reordered clustering which is consistent, wherever possible, the ideal order.
}
\description{
Given a clustering of some data, and some ideal order we'd like to use to visualize it, reorder
(but do not modify) the clustering to be as consistent as possible with this ideal order.
}
\examples{
clusters <- hclust(dist(mtcars))
clusters$order
clusters <- slanter::reorder_hclust(clusters, 1:length(clusters$order))
clusters$order
}
