% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_slackr.R, R/zcamels.r
\name{save_slackr}
\alias{save_slackr}
\alias{save.slackr}
\title{Save R objects to an RData file on Slack}
\usage{
save_slackr(
  ...,
  channels = "",
  file = "slackr",
  bot_user_oauth_token = Sys.getenv("SLACK_BOT_USER_OAUTH_TOKEN")
)

save.slackr(
  ...,
  channels = "",
  file = "slackr",
  bot_user_oauth_token = Sys.getenv("SLACK_BOT_USER_OAUTH_TOKEN")
)
}
\arguments{
\item{...}{objects to store in the R data file}

\item{channels}{Slack channels to save to (optional)}

\item{file}{filename (without extension) to use}

\item{bot_user_oauth_token}{Slack bot user OAuth token}
}
\value{
\code{httr} response object from \code{POST} call
}
\description{
\code{save_slackr} enables you upload R objects (as an R data file)
to Slack and (optionally) post them to one or more channels
(if \code{channels} is not empty).
}
\note{
You can pass in \code{add_user=TRUE} as part of the \code{...} parameters and the Slack API
      will post the message as your logged-in user account (this will override anything set in
      \code{username})
}
\examples{
\dontrun{
slackr_setup()
save_slackr(mtcars, channels="#slackr", file="mtcars")
}
}
\seealso{
\code{\link{slackr_setup}}, \code{\link{dev_slackr}}, \code{\link{slackr_upload}}
}
