% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sig-test.R
\name{nh.SummerFM}
\alias{nh.SummerFM}
\title{Declination distribution of the Summer Full Moon
 for null hypothesis significance testing}
\usage{
nh.SummerFM(min.phase = 0.99, min.sundec = 20, year = cur.year)
}
\arguments{
\item{min.phase}{(Optional) This should be the minimum
lunar phase (i.e. percentage illumination) for the moon
 to be considered full. The value should range between
 0 (dark moon) and 1 (full moon). Defaults to 0.99.}

\item{min.sundec}{(Optional) This should be the minimum
solar declination for the moon to be considered a
\emph{summmer} full moon. Defaults to 20 degrees,
corresponding to a month before or after june solstice.}

\item{year}{Year for which to calculate the obliquity.
Defaults to present year as given by Sys.Date()}
}
\description{
This function returns the declination distribution of
the Summer Full Moon for use in significance testing.
}
\examples{
\dontrun{
aux <- nh.SummerFM(.99, 20, -4000)
plot(aux$dec, aux$density, type='l')
}
}
\seealso{
\code{\link{sigTest}}, \code{\link{nh.Uniform}}, \code{\link{nh.SolarRange}}
}
