% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sklarsomega.R
\name{confint.sklarsomega}
\alias{confint.sklarsomega}
\title{Compute confidence/credible intervals for Sklar's Omega.}
\usage{
\method{confint}{sklarsomega}(object, parm, level = 0.95, ...)
}
\arguments{
\item{object}{an object of class \code{"sklarsomega"}, the result of a call to \code{\link{sklars.omega}}.}

\item{parm}{a specification of which parameters are to be given confidence intervals, either a vector of numbers or a vector of names. If missing, all parameters are considered.}

\item{level}{the desired confidence level for the interval. The default value is 0.95.}

\item{\dots}{additional arguments. These are passed to \code{\link{quantile}} if \code{confint} is equal to \code{"bootstrap"}.}
}
\value{
A vector with entries giving lower and upper confidence limits. These will be labelled as (1 - level) / 2 and 1 - (1 - level) / 2.
}
\description{
Compute confidence/credible intervals for Sklar's Omega.
}
\details{
This function computes confidence/credible intervals for a Sklar's Omega fit.
}
\examples{
# Fit a subset of the cartilage data, assuming a Laplace marginal distribution. Compute
# confidence intervals in the usual ML way (observed information matrix). Note that
# calling function sklars.omega with confint = bootstrap will lead to bootstrap sampling,
# in which case confidence intervals will be bootstrap intervals.

data(cartilage)
data.cart = as.matrix(cartilage)[1:100, ]
colnames(data.cart) = c("c.1.1", "c.2.1")
fit.lap = sklars.omega(data.cart, level = "balance", confint = "asymptotic",
                       control = list(dist = "laplace"))
summary(fit.lap)
confint(fit.lap, level = 0.99)
}
\references{
Nissi, M. J., Mortazavi, S., Hughes, J., Morgan, P., and Ellermann, J. (2015). T2* relaxation time of acetabular and femoral cartilage with and without intra-articular Gd-DTPA2 in patients with femoroacetabular impingement. \emph{American Journal of Roentgenology}, \bold{204}(6), W695.
}
\seealso{
\code{\link{sklars.omega}}
}
