% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_write.R
\name{read_stata}
\alias{read_stata}
\title{Import STATA dataset as data frame into R}
\usage{
read_stata(path, atomic.to.fac = FALSE)
}
\arguments{
\item{path}{File path to the data file.}

\item{atomic.to.fac}{Logical, if \code{TRUE}, factor variables imported from
the dataset (which are imported as \code{\link{atomic}}) will be converted
to \code{\link{factor}}s.}
}
\value{
A data frame containing the STATA data. Retrieve value labels with \code{\link{get_labels}}
  and variable labels with \code{\link{get_label}}.
}
\description{
Imports data from STATA dta-files, including NA's,
               value and variable labels.
}
\note{
This is a wrapper function for \code{\link[haven]{read_dta}} function of the
        \pkg{haven} package. This function converts the imported data
        into a common class format (see \code{\link{unlabel}}).
}
\seealso{
\code{\link{read_spss}}
}

