% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjImportSPSS.R
\name{set_val_labels}
\alias{set_val_labels}
\title{Attach value labels to variables}
\usage{
set_val_labels(x, labels, force.labels = FALSE)
}
\arguments{
\item{x}{a variable (vector), \code{list} of variables or a \code{data.frame}
where value labels should be attached. Replaces former value labels.}

\item{labels}{a character vector of labels that will be attached to \code{x} by setting
the \code{"labels"} or \code{"value.labels"} attribute. The length of this character vector must equal
the value range of \code{x}, i.e. if \code{x} has values from 1 to 3,
\code{labels} should have a length of 3.
If \code{x} is a data frame, \code{labels} may also be a \code{\link{list}} of
character vectors. If \code{labels} is a list, it must have the same length as
number of columns of \code{x}. If \code{labels} is a vector and \code{x} is a data frame,
the \code{labels} will be applied to each column of \code{x}.
Use \code{labels = ""} to remove labels-attribute from \code{x}.}

\item{force.labels}{logical; if \code{TRUE}, all \code{labels} are added as value labels
attribute, even if \code{x} has less unique values then length of \code{labels}
or if \code{x} has a smaller range then length of \code{labels}. See 'Examples'.}
}
\value{
\code{x} with attached value labels; or with removed label-attribute if
           \code{labels = ""}.
}
\description{
This function adds character labels as attribute to a variable
               or vector \code{x}, resp. to a set of variables in a
               \code{data.frame} or \code{list}-object. To each variable,
               the attribute \code{"labels"} or \code{"value.labels"}
               with the related \code{labels} is attached. These value labels will be accessed
               by functions of the \emph{sjPlot} package, in order to automatically set values
               or legend labels.
}
\details{
See 'Details' in \code{\link{get_val_labels}}
}
\note{
See 'Note' in \code{\link{get_val_labels}}
}
\examples{
\dontrun{
library(sjPlot)
dummy <- sample(1:4, 40, replace=TRUE)
sjp.frq(dummy)

dummy <- set_val_labels(dummy, c("very low", "low", "mid", "hi"))
sjp.frq(dummy)}

# force using all labels, even if not all labels
# have associated values in vector
x <- c(2, 2, 3, 3, 2)
# only two value labels
x <- set_val_labels(x, c("1", "2", "3"))
x
\dontrun{sjp.frq(x)}
# all three value labels
x <- set_val_labels(x, c("1", "2", "3"), force.labels = TRUE)
x
\dontrun{sjp.frq(x)}

# setting same value labels to multiple vectors

# create a set of dummy variables
dummy1 <- sample(1:4, 40, replace=TRUE)
dummy2 <- sample(1:4, 40, replace=TRUE)
dummy3 <- sample(1:4, 40, replace=TRUE)
# put them in list-object
dummies <- list(dummy1, dummy2, dummy3)
# and set same value labels for all three dummies
dummies <- set_val_labels(dummies, c("very low", "low", "mid", "hi"))
# see result...
get_val_labels(dummies)
}
\seealso{
The sjPlot manual on \href{http://www.strengejacke.de/sjPlot/datainit/}{data initialization} or
           \href{http://www.strengejacke.de/sjPlot/view_spss/}{inspecting (SPSS imported) data frames} for
           more details; \code{\link{set_var_labels}} to manually set variable labels or
           \code{\link{get_var_labels}} to get variable labels.
}

