\name{sjc.dend}
\alias{sjc.dend}
\title{Compute hierarchical cluster analysis and visualize group classification}
\usage{
sjc.dend(data, groupcount, distance = "euclidean", agglomeration = "ward")
}
\arguments{
  \item{data}{The data frame containing all variables that
  should be used for the cluster analysis.}

  \item{groupcount}{The amount of groups (clusters) that
  should be used.  \itemize{ \item Use
  \code{\link{sjc.elbow}}-function to determine the
  group-count depending on the elbow-criterion.  \item If
  using kmeans as \code{method}, use
  \code{\link{sjc.kgap}}-function to determine the
  group-count according to the gap-statistic.  \item Use
  \code{\link{sjc.grpdisc}}-function to inspect the
  goodness of grouping (accuracy of classification).  }
  Solutions for multiple cluster groups can be plotted, for
  instance with \code{"groupcount=c(3:6)"}.}

  \item{distance}{The distance measure to be used. This
  must be one of \code{"euclidean"} (default),
  \code{"maximum"}, \code{"manhattan"}, \code{"canberra"},
  \code{"binary"} or \code{"minkowski"}. See
  \code{\link{dist}}.}

  \item{agglomeration}{The agglomeration method to be used.
  This should be one of \code{"ward"}, \code{"single"},
  \code{"complete"}, \code{"average"}, \code{"mcquitty"},
  \code{"median"} or \code{"centroid"}. Default is
  \code{"ward"}. See \code{\link{hclust}}.}
}
\description{
Computes a hierarchical cluster analysis and plots a
hierarchical dendrogram with highlighting rectangles around
the classified groups.  Can be used, for instance, as
visual tool to verify the elbow-criterion (see
\code{\link{sjc.elbow}}).
}
\examples{
# Plot dendrogram of hierarchical clustering of mtcars-dataset
# and show group classification
sjc.dend(mtcars, 5)

# Plot dendrogram of hierarchical clustering of mtcars-dataset
# and show group classification for 2 to 4 groups
sjc.dend(mtcars, 2:4)
}
\seealso{
\code{\link{sjc.cluster}} \cr \code{\link{sjc.grpdisc}} \cr
\code{\link{sjc.elbow}}
}

