% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checking_data.R
\name{agrupar_per_etn}
\alias{agrupar_per_etn}
\title{Agrupar por la pertenencia étnica}
\usage{
agrupar_per_etn(data_event, cols_etn = "per_etn", porcentaje = TRUE)
}
\arguments{
\item{data_event}{Un `data.frame` que contiene los datos de la
enfermedad o evento.}

\item{cols_etn}{Un `character` (cadena de caracteres) o un `array` de
`character` con el nombre de la(s) columna(s) que contiene(n) la
pertenencia étnica en los datos de la enfermedad o evento;
su valor por defecto es `"per_etn"`}

\item{porcentaje}{Un `logical` (TRUE o FALSE) que indica
si se debe agregar una columna con el porcentaje de casos;
su valor por defecto es `TRUE`.}
}
\value{
Un `data.frame` con los datos de la enfermedad o evento agrupados
por la pertenencia étnica.
}
\description{
Función que agrupa los casos por la pertenencia étnica.
}
\examples{
data(dengue2020)
data_limpia <- limpiar_data_sivigila(data_event = dengue2020)
agrupar_per_etn(
  data_event = data_limpia,
  cols_etn = "per_etn"
)
}
