% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_summary.R
\name{summary.class_cube}
\alias{summary.class_cube}
\title{Summarize data cubes}
\usage{
\method{summary}{class_cube}(object, ..., tile = NULL)
}
\arguments{
\item{object}{Object of class "class_cube"}

\item{...}{Further specifications for \link{summary}.}

\item{tile}{Tile to be summarized}
}
\value{
A summary of a classified cube
}
\description{
This is a generic function. Parameters depend on the specific
type of input.
}
\examples{
if (sits_run_examples()) {
    # create a data cube from local files
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6.1",
        data_dir = data_dir
    )
    # create a random forest model
    rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
    # classify a data cube
    probs_cube <- sits_classify(
        data = cube, ml_model = rfor_model, output_dir = tempdir()
    )
    # label the probability cube
    label_cube <- sits_label_classification(
        probs_cube,
        output_dir = tempdir()
    )
    summary(label_cube)
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
