% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_som.R
\name{sits_som_remove_samples}
\alias{sits_som_remove_samples}
\title{Evaluate cluster}
\usage{
sits_som_remove_samples(som_map, som_eval, class_cluster, class_remove)
}
\arguments{
\item{som_map}{A SOM map produced by the som_map() function}

\item{som_eval}{An evaluation produced by the som_eval() function}

\item{class_cluster}{Dominant class of a set of neurons}

\item{class_remove}{Class to be removed from the neurons of the "class_cluster"}
}
\value{
A new set of samples with the desired class neurons remove
}
\description{
Remove samples from a given class inside a neuron of another class
}
\examples{
if (sits_run_examples()) {
    # create a som map
    som_map <- sits_som_map(samples_modis_ndvi)
    # evaluate the som map and create clusters
    som_eval <- sits_som_evaluate_cluster(som_map)
    # clean the samples
    new_samples <- sits_som_remove_samples(som_map, som_eval, "Pasture", "Cerrado")
}
}
