% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_segmentation.R
\name{sits_segment}
\alias{sits_segment}
\title{Segment an image}
\usage{
sits_segment(cube, tiles = NULL, bands = NULL, dates = NULL, seg_fn, ...)
}
\arguments{
\item{cube}{Regular data cube}

\item{tiles}{Tiles to be segmented}

\item{bands}{Bands to include in the segmentation}

\item{dates}{Dates to consider to be segmented}

\item{seg_fn}{Function to apply the segmentation}

\item{...}{Other params to be passed to segmentation function}
}
\value{
A list of "sf" objects, indexed by tile.
                     Each "sf" object contains the polygons that define
                     the segments.
}
\description{
Apply a spatial segmentation on a data cube based on a user defined
segmentation function. The user defines the tiles of
the cube to be segmented and informs the bands and the date to
be used. The function applies the segmentation algorithm
"seg_fn" to each tile.

Segmentation uses the following steps:
\itemize{
 \item{use \code{\link[sits]{sits_segment}} to obtain the \code{sf}
       polygons that define the boundary of the segments.}
 \item{use \code{\link[sits]{sits_get_data}} to obtain one time series
       associated to each segment.}
 \item{use \code{\link[sits]{sits_classify}} to classify the
      time series associated to the segments.}
 \item{use \code{\link[sits]{sits_join_segments}} to update the class
      for each segment, based on the time series classification.}
 \item{use \code{\link[sits]{plot}} or \code{\link[sits]{sits_view}}
       to display the results.}
 \item{The result of \code{\link[sits]{sits_join_segments}} is a
       list of \code{sf} objects with a "class" attribute.
       Use the functions available in \code{sf} for further analysis.}
 }
}
\examples{
if (sits_run_examples()) {
data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
# create a data cube
cube <- sits_cube(
    source = "BDC",
    collection = "MOD13Q1-6",
    data_dir = data_dir
)

# segment the image
segments <- sits_segment(
    cube = cube,
    tile = "012010",
    bands = "NDVI",
    dates = sits_timeline(cube)[1],
    seg_fn = sits_supercells(step = 20)
)
# create a classification model
rfor_model <- sits_train(samples_modis_ndvi, sits_rfor())
# get the average value per segment
samples_seg <- sits_get_data(
    cube = cube,
    samples = segments
)
# classify the segments
seg_class <- sits_classify(
    data = samples_seg,
    ml_model = rfor_model
)
# add a column to the segments by class
sf_seg <- sits_join_segments(
    data = seg_class,
    segments = segments
)
}

}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}

Rolf Simoes, \email{rolf.simoes@inpe.br}

Felipe Carvalho, \email{felipe.carvalho@inpe.br}
}
