% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate}
\alias{simulate}
\alias{simulate.singleRStaticCountData}
\alias{simulate.singleRfamily}
\title{Generating data in singleRcapture}
\usage{
\method{simulate}{singleRStaticCountData}(object, nsim = 1, seed = NULL, ...)

\method{simulate}{singleRfamily}(object, nsim, seed = NULL, eta, truncated = FALSE, ...)
}
\arguments{
\item{object}{an object representing a fitted model.}

\item{nsim}{a numeric scalar specifying:
\itemize{
\item number of response vectors to simulate in \code{simulate.singleRStaticCountData}, defaults to \code{1L}.
\item number of units to draw in \code{simulate.singleRfamily}, defaults to \code{NROW(eta)}.
}}

\item{seed}{an object specifying if and how the random number generator should be initialized (‘seeded’).}

\item{...}{additional optional arguments.}

\item{eta}{a matrix of linear predictors}

\item{truncated}{logical value indicating whether to sample from truncated or
full distribution.}
}
\value{
a \code{data.frame} with \code{n} rows and \code{nsim} columns.
}
\description{
An S3 method for \code{stats::simulate} to handle \code{singleRStaticCountData} and
\code{singleRfamily} classes.
}
\examples{
N <- 10000
###gender <- rbinom(N, 1, 0.2)
gender <- rep(0:1, c(8042, 1958))
eta <- -1 + 0.5*gender
counts <- simulate(ztpoisson(), eta = cbind(eta), seed = 1)
df <- data.frame(gender, eta, counts)
df2 <- subset(df, counts > 0)
### check coverage with summary
mod1 <-  estimatePopsize(
  formula       = counts ~ 1 + gender, 
  data          = df2, 
  model         = ztpoisson, 
  controlMethod = list(silent = TRUE)
)
mod1_sims <- simulate(mod1, nsim=10, seed = 1)
colMeans(mod1_sims)
mean(df2$counts)
}
\seealso{
\code{\link[stats:simulate]{stats::simulate()}} \code{\link[=estimatePopsize]{estimatePopsize()}}
}
\author{
Maciej Beręsewicz, Piotr Chlebicki
}
