% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control.R
\name{controlMethod}
\alias{controlMethod}
\title{Control parameters for regression}
\usage{
controlMethod(
  epsilon = 1e-08,
  maxiter = 1000,
  verbose = 0,
  printEveryN = 1L,
  start = NULL,
  optimMethod = "L-BFGS-B",
  silent = FALSE,
  optimPass = FALSE,
  stepsize = 1,
  checkDiagWeights = TRUE,
  weightsEpsilon = 1e-08,
  momentumFactor = 0,
  saveIRLSlogs = FALSE,
  momentumActivation = 5,
  criterion = c("coef", "abstol", "reltol")
)
}
\arguments{
\item{epsilon}{tolerance for fitting algorithms by default \code{1e-8}.}

\item{maxiter}{maximum number of iterations.}

\item{verbose}{value indicating whether to trace steps of fitting algorithm for
\code{IRLS} fitting method different values of verbose give the following information:
\itemize{
\item 1 -- Returns information on the number of current
iteration and current log-likelihood.
\item 2 -- Returns information on vector of regression parameters
at current iteration (and all of the above).
\item 3 -- Returns information on reduction of log-likelihood
at current iteration (and all of the above).
\item 4 -- Returns information on value of log-likelihood function gradient
at current iteration (and all of the above).
\item 5 -- Returns information on convergence criterion and values that are
taken into account when considering convergence (and all of the above).
}
if \code{optim} method was chosen verbose will be passed to \code{\link[stats:optim]{stats::optim()}} as trace.}

\item{printEveryN}{integer value indicating how often to print information
specified in \code{verbose}, by default set to \code{1}.}

\item{start}{initial parameters for regression coefficients
if \code{NULL} they will be derived internally.}

\item{optimMethod}{method of \code{\link[stats:optim]{stats::optim()}} used L-BFGS-B is the default
except for negative binomial and one inflated models where \code{"Nelder-Mead"} is used.}

\item{silent}{logical, indicating whether warnings in \code{IRLS} method should be suppressed.}

\item{optimPass}{optional list of parameters passed to \code{stats::optim(..., control = optimPass)}
if FALSE then list of control parameters will be inferred from other parameters.}

\item{stepsize}{only for \code{IRLS}, scaling of updates to \code{beta} vector
lower value means slower convergence but more accuracy by default 1.
In general if fitting algorithm fails lowering this value tends to
be most effective at correcting it.}

\item{checkDiagWeights}{logical value indicating whether to check if diagonal
elements of working weights matrixes in \code{IRLS} are sufficiently positive
so that these matrixes are positive defined. By default \code{TRUE}.}

\item{weightsEpsilon}{small number to ensure positivity of weights matrixes.
Only matters if \code{checkDiagWeights} is set to \code{TRUE}.
By default \code{1e-8}.}

\item{momentumFactor}{experimental parameter in \code{IRLS} only allowing for
taking previous step into account at current step, i.e instead of
updating regression parameters as:
\mjsdeqn{\boldsymbol{\beta}_{(a)} = 
\boldsymbol{\beta}_{(a-1)} + \text{stepsize} \cdot \text{step}_{(a)}}
the update will be made as:
\mjsdeqn{
\boldsymbol{\beta}_{(a)} = \boldsymbol{\beta}_{(a-1)} + \text{stepsize} 
\cdot (\text{step}_{(a)} + \text{momentum}\cdot\text{step}_{(a-1)})}}

\item{saveIRLSlogs}{logical value indicating if information specified in
\code{verbose} should be saved to output object, by default \code{FALSE}.}

\item{momentumActivation}{the value of log-likelihood reduction bellow
which momentum will apply.}

\item{criterion}{criterion used to determine convergence in \code{IRLS},
multiple values may be provided. By default \code{c("coef", "abstol")}.}
}
\value{
List with selected parameters, it is also possible to call list directly.
}
\description{
\code{controlMethod} constructs a list with all necessary
control parameters for regression fitting in
\code{estimatePopsize.fit} and \code{estimatePopsize}.
}
\seealso{
\code{\link[=estimatePopsize]{estimatePopsize()}} \code{\link[=estimatePopsize.fit]{estimatePopsize.fit()}}
\code{\link[=controlModel]{controlModel()}} \code{\link[=controlPopVar]{controlPopVar()}}
}
\author{
Piotr Chlebicki, Maciej Beręsewicz
\loadmathjax
}
