% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation-class.R
\name{new_simulation}
\alias{new_simulation}
\title{Make a new simulation object}
\usage{
new_simulation(name, label, dir = ".", refs = list(), save_to_file = TRUE)
}
\arguments{
\item{name}{a short name identifier.  Must be alphanumeric.}

\item{label}{a longer, human readable label that can have other characters
such as spaces, hyphens, etc.}

\item{dir}{a directory that reference's directories are relative to}

\item{refs}{a list containing objects of class \code{\linkS4class{ModelRef}},
\code{\linkS4class{DrawsRef}}, \code{\linkS4class{OutputRef}},
and \code{\linkS4class{EvalsRef}}}

\item{save_to_file}{whether this new simulation should be saved to file.
Default is TRUE. If TRUE, then this simulation can be loaded
in a new R session using \code{dir} and \code{name}.}
}
\description{
Creates an object of class \code{\linkS4class{Simulation}}.  In addition to having
a name and label, this object consists of a set of references to objects of
class \code{\linkS4class{ModelRef}}, \code{\linkS4class{DrawsRef}},
\code{\linkS4class{OutputRef}}, and \code{\linkS4class{EvalsRef}}.
}
\details{
A Simulation object is the basic unit of a simulation study.  Roughly, one
can think of it as all the files relevant to a single figure. This might be
a single plot or a series of related plots/panels.  It could also correspond
to a single table.  Note that a Simulation object is light-weight even for
large simulations because it only stores references to the objects
not the objects themselves.  The functions \code{\link{model}},
\code{\link{draws}}, \code{\link{output}}, \code{\link{evals}} can be used
to load individual objects of a simulation.

The Simulation object created is saved to a file so that it can be loaded
in a new R session.  The simulation is saved in dir/files/name.Rdata. Note:
while "files" is the default, the name of this directory is from
getOption("simulator.files"), which is the value of
getOption("simulator.files") when the model was created.
}
\examples{
sim <- new_simulation(name = "normal-example",
                       label = "Normal Mean Estimation",
                       dir = tempdir())
}
\seealso{
\code{\link{load_simulation}} \code{\link{save_simulation}}
}

