% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmwm.r
\name{plot.gmwm}
\alias{plot.gmwm}
\title{Plot the GMWM with the Wavelet Variance}
\usage{
\method{plot}{gmwm}(
  x,
  decomp = FALSE,
  units = NULL,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  col_wv = NULL,
  col_ci = NULL,
  nb_ticks_x = NULL,
  nb_ticks_y = NULL,
  legend_position = NULL,
  ci_wv = NULL,
  point_cex = NULL,
  point_pch = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{gmwm} object.}

\item{decomp}{A \code{boolean} that determines whether the contributions of each individual model are plotted.}

\item{units}{A \code{string} that specifies the units of time plotted on the x axis.}

\item{xlab}{A \code{string} that gives a title for the x axis.}

\item{ylab}{A \code{string} that gives a title for the y axis.}

\item{main}{A \code{string} that gives an overall title for the plot.}

\item{col_wv}{A \code{string} that specifies the color of the wavelet variance line.}

\item{col_ci}{A \code{string} that specifies the color of the shaded area covered by the confidence intervals.}

\item{nb_ticks_x}{An \code{integer} that specifies the maximum number of ticks for the x-axis.}

\item{nb_ticks_y}{An \code{integer} that specifies the maximum number of ticks for the y-axis.}

\item{legend_position}{A \code{string} that specifies the position of the legend (use \code{legend_position = NA} to remove legend).}

\item{ci_wv}{A \code{boolean} that determines whether to plot the confidence interval shaded area.}

\item{point_cex}{A \code{double} that specifies the size of each symbol to be plotted.}

\item{point_pch}{A \code{double} that specifies the symbol type to be plotted.}

\item{...}{Additional arguments affecting the plot.}
}
\value{
Plot of WV and relative confidence intervals for each scale.
}
\description{
Displays a plot of the Wavelet Variance (WV) with the CI values and the WV implied by the estimated parameters.
}
\author{
Stephane Guerrier and Yuming Zhang
}
